package cn.schoolwow.workflow.module.task.flow.listener;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.domain.task.CompleteTaskRequest;
import cn.schoolwow.workflow.domain.task.WorkFlowTaskResponse;
import cn.schoolwow.workflow.module.parent.domain.QuickWorkFlowOption;

public class ExecuteAfterCompleteTaskListenerFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickWorkFlowOption quickWorkFlowOption = (QuickWorkFlowOption) flowContext.checkData("quickWorkFlowOption");

        if(null==quickWorkFlowOption.workFlowTaskListener){
            return;
        }
        CompleteTaskRequest completeTaskRequest = (CompleteTaskRequest) flowContext.checkData("completeTaskRequest");
        WorkFlowTaskResponse beforeWorkFlowTaskResponse = (WorkFlowTaskResponse) flowContext.checkData("beforeWorkFlowTaskResponse");
        beforeWorkFlowTaskResponse.complete = true;

        quickWorkFlowOption.workFlowTaskListener.afterTaskComplete(beforeWorkFlowTaskResponse, completeTaskRequest.taskType);
    }

    @Override
    public String name() {
        return "执行工作流任务完成之后事件";
    }
}
