package cn.schoolwow.workflow.module.task.flow.complete;

import cn.schoolwow.quickdao.domain.transaction.Transaction;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.domain.task.CompleteTaskRequest;
import cn.schoolwow.workflow.entity.WorkFlowTask;

public class UpdateWorkFlowTaskStatusFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Transaction transaction = (Transaction) flowContext.checkData("transaction");
        CompleteTaskRequest completeTaskRequest = (CompleteTaskRequest) flowContext.checkData("completeTaskRequest");

        transaction.query(WorkFlowTask.class)
                .addQuery("id", completeTaskRequest.taskId)
                .addUpdate("complete", true)
                .execute()
                .update();
    }

    @Override
    public String name() {
        return "完成流程任务-修改任务状态";
    }
}
