package cn.schoolwow.workflow.module.task.flow.complete;

import cn.schoolwow.quickdao.domain.database.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.transaction.Transaction;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.entity.WorkFlowInstance;
import cn.schoolwow.workflow.entity.WorkFlowNode;

public class UpdateWorkFlowInstanceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Transaction transaction = (Transaction) flowContext.checkData("transaction");
        WorkFlowInstance workFlowInstance = (WorkFlowInstance) flowContext.checkData("workFlowInstance");
        WorkFlowNode nextNode = (WorkFlowNode) flowContext.checkData("nextNode");

        Condition condition = transaction.query(WorkFlowInstance.class)
                .addQuery("id", workFlowInstance.getId())
                .addQuery("definitionId", workFlowInstance.getDefinitionId())
                .addUpdate("contextData", workFlowInstance.getContextData())
                .addUpdate("workFlowNodeId", nextNode.getId());
        if(nextNode.getType()==2){
            condition.addUpdate("finished", true);
        }
        condition.execute().update();
    }

    @Override
    public String name() {
        return "完成流程任务-更新工作流实例";
    }
}
