package cn.schoolwow.workflow.module.task.flow.complete;

import cn.schoolwow.quickdao.domain.DAO;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.domain.task.CompleteTaskRequest;
import cn.schoolwow.workflow.entity.WorkFlowInstance;
import cn.schoolwow.workflow.entity.WorkFlowNode;
import cn.schoolwow.workflow.entity.WorkFlowTask;
import cn.schoolwow.workflow.module.parent.flow.SetNextNodeFlow;
import org.apache.commons.lang3.Validate;

public class QueryTaskNextNodeFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setWorkFlowInstance(flowContext);
        setNextNode(flowContext);
    }

    @Override
    public String name() {
        return "完成流程任务-查询下一节点信息";
    }

    private void setWorkFlowInstance(FlowContext flowContext){
        DAO dao = (DAO) flowContext.checkData("dao");
        CompleteTaskRequest completeTaskRequest = (CompleteTaskRequest) flowContext.checkData("completeTaskRequest");

        WorkFlowInstance workFlowInstance = (WorkFlowInstance) dao.query(WorkFlowInstance.class)
                .joinTable(WorkFlowTask.class, "id", "instanceId")
                .addQuery("id", completeTaskRequest.taskId)
                .done()
                .execute()
                .getOne();
        Validate.notNull(workFlowInstance, "任务所属流工作流实例不存在!任务id:"+completeTaskRequest.taskId);
        if(workFlowInstance.isFinished()){
            throw new IllegalArgumentException("任务所属流程实例状态为已完成!任务id:"+completeTaskRequest.taskId);
        }
        workFlowInstance.getContextData().putAll(completeTaskRequest.contextData);
        flowContext.putTemporaryData("workFlowInstance", workFlowInstance);
    }

    private void setNextNode(FlowContext flowContext){
        DAO dao = (DAO) flowContext.checkData("dao");
        CompleteTaskRequest completeTaskRequest = (CompleteTaskRequest) flowContext.checkData("completeTaskRequest");
        WorkFlowInstance workFlowInstance = (WorkFlowInstance) flowContext.checkData("workFlowInstance");

        WorkFlowNode currentWorkflowNode = dao.query(WorkFlowNode.class)
                .addQuery("id", workFlowInstance.getWorkFlowNodeId())
                .execute()
                .getOne();
        flowContext.putTemporaryData("currentWorkflowNode", currentWorkflowNode);

        flowContext.startFlow(new SetNextNodeFlow())
                .putCurrentCompositeFlowData("definitionId", workFlowInstance.getDefinitionId())
                .putCurrentCompositeFlowData("taskType", completeTaskRequest.taskType)
                .execute();
    }
}
