package cn.schoolwow.workflow.module.task.flow.complete;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.domain.task.CompleteTaskRequest;
import org.apache.commons.lang3.Validate;

public class CheckCompleteTaskRequestFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        CompleteTaskRequest completeTaskRequest = (CompleteTaskRequest) flowContext.checkData("completeTaskRequest");

        Validate.notNull(completeTaskRequest.taskId, "任务id不能为空");
        Validate.notNull(completeTaskRequest.taskType, "完成任务类型不能为空");
    }

    @Override
    public String name() {
        return "检查完成任务请求参数";
    }
}
