package cn.schoolwow.workflow.module.task.flow.complete;

import cn.schoolwow.quickdao.domain.transaction.Transaction;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.domain.task.CompleteTaskRequest;
import cn.schoolwow.workflow.entity.WorkFlowHistory;
import cn.schoolwow.workflow.entity.WorkFlowInstance;
import cn.schoolwow.workflow.entity.WorkFlowNode;

public class AddWorkFlowHistoryFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        WorkFlowInstance workFlowInstance = (WorkFlowInstance) flowContext.checkData("workFlowInstance");
        WorkFlowNode currentWorkflowNode = (WorkFlowNode) flowContext.checkData("currentWorkflowNode");
        CompleteTaskRequest completeTaskRequest = (CompleteTaskRequest) flowContext.checkData("completeTaskRequest");
        Transaction transaction = (Transaction) flowContext.checkData("transaction");

        WorkFlowHistory workFlowHistory = new WorkFlowHistory();
        workFlowHistory.setWorkFlowDefinitionId(workFlowInstance.getDefinitionId());
        workFlowHistory.setWorkFlowInstanceId(workFlowInstance.getId());
        workFlowHistory.setWorkFlowNodeId(currentWorkflowNode.getId());
        workFlowHistory.setCondition(completeTaskRequest.taskType.code);
        transaction.insert(workFlowHistory);
    }

    @Override
    public String name() {
        return "添加工作流操作历史记录";
    }

}
