package cn.schoolwow.workflow.module.parent.kit;

import cn.schoolwow.workflow.module.definition.kit.WorkFlowDeploy;
import cn.schoolwow.workflow.module.definition.kit.WorkFlowDeployImpl;
import cn.schoolwow.workflow.module.instance.kit.WorkFlowInstanceService;
import cn.schoolwow.workflow.module.instance.kit.WorkFlowInstanceServiceImpl;
import cn.schoolwow.workflow.module.parent.domain.QuickWorkFlowConfig;
import cn.schoolwow.workflow.module.task.kit.WorkFlowTaskService;
import cn.schoolwow.workflow.module.task.kit.WorkFlowTaskServiceImpl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * 代理模式对象
 */
public class WorkFlowInvocationHandler implements InvocationHandler {
    private WorkFlowOption workFlowOption;
    private WorkFlowDeploy workFlowDeploy;
    private WorkFlowInstanceService workFlowExecute;
    private WorkFlowTaskService workFlowTaskService;
    private Object[] interfaceInstanceArray;

    public WorkFlowInvocationHandler(QuickWorkFlowConfig quickWorkFlowConfig) {
        workFlowOption = new WorkFlowOptionImpl(quickWorkFlowConfig);
        workFlowDeploy = new WorkFlowDeployImpl(quickWorkFlowConfig);
        workFlowExecute = new WorkFlowInstanceServiceImpl(quickWorkFlowConfig);
        workFlowTaskService = new WorkFlowTaskServiceImpl(quickWorkFlowConfig);
        interfaceInstanceArray = new Object[]{
                workFlowOption,
                workFlowDeploy,
                workFlowExecute,
                workFlowTaskService
        };
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String interfaceName = method.getDeclaringClass().getSimpleName();
        for(Object interfaceInstance:interfaceInstanceArray){
            Class interfaceClass = interfaceInstance.getClass().getInterfaces()[0];
            if(interfaceClass.getSimpleName().equalsIgnoreCase(interfaceName)){
                try {
                    return method.invoke(interfaceInstance, args);
                }catch (InvocationTargetException e){
                    Throwable targetException = e.getTargetException();
                    throw targetException;
                }
            }
        }
        throw new IllegalAccessError("不支持调用该方法!方法名:"+method.getName());
    }
}
