package cn.schoolwow.workflow.module.parent.flow;

import cn.schoolwow.quickdao.domain.DAO;
import cn.schoolwow.quickdao.domain.database.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.database.dql.subCondition.SubCondition;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.domain.task.TaskType;
import cn.schoolwow.workflow.entity.WorkFlowNode;
import cn.schoolwow.workflow.entity.WorkFlowNodeJump;

public class SetNextNodeFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        checkCurrentWorkFlowNode(flowContext);
        setNextNode(flowContext);
    }

    @Override
    public String name() {
        return "查询并设置流程后继节点";
    }

    private void checkCurrentWorkFlowNode(FlowContext flowContext){
        WorkFlowNode currentWorkflowNode = (WorkFlowNode) flowContext.checkData("currentWorkflowNode");

        if(currentWorkflowNode.getType()!=2){
            return;
        }

        if(flowContext.containKey("taskId")){
            long taskId = (long) flowContext.checkData("taskId");
            throw new IllegalArgumentException("当前节点已经是结束节点!当前节点id:"+currentWorkflowNode.getId()+",节点名称:"+currentWorkflowNode.getName()+",任务id:"+taskId);
        }else if(flowContext.containKey("name")){
            String name = (String) flowContext.checkData("name");
            throw new IllegalArgumentException("当前节点已经是结束节点!当前节点id:"+currentWorkflowNode.getId()+",节点名称:"+currentWorkflowNode.getName()+",流程定义名称:"+name);
        }else{
            throw new IllegalArgumentException("当前节点已经是结束节点!当前节点id:"+currentWorkflowNode.getId()+",节点名称:"+currentWorkflowNode.getName());
        }
    }

    private void setNextNode(FlowContext flowContext){
        DAO dao = (DAO) flowContext.checkData("dao");
        long definitionId = (long) flowContext.checkData("definitionId");
        WorkFlowNode currentWorkflowNode = (WorkFlowNode) flowContext.checkData("currentWorkflowNode");
        TaskType taskType = (TaskType) flowContext.getData("taskType");

        Condition condition = dao.query(WorkFlowNode.class)
                .addTableColumn()
                .addQuery("definitionId", definitionId);

        SubCondition workFlowJumpSubCondition = condition.joinTable(WorkFlowNodeJump.class, "id", "nextNodeId")
                .on("definitionId", "definitionId")
                .addQuery("currentNodeId", currentWorkflowNode.getId());
        if(null!=taskType){
            workFlowJumpSubCondition.addQuery("condition", taskType.code);
        }

        WorkFlowNode nextNode = (WorkFlowNode) condition
                .execute()
                .getOne(WorkFlowNode.class);
        if(null==nextNode){
            throw new IllegalArgumentException("当前节点的后续节点不存在!当前节点名称:"+currentWorkflowNode.getName());
        }
        flowContext.putTemporaryData("nextNode", nextNode);
    }
}
