package cn.schoolwow.workflow.module.parent.flow;

import cn.schoolwow.quickdao.domain.database.dml.UpdateType;
import cn.schoolwow.quickdao.domain.transaction.Transaction;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.domain.instance.StartWorkFlowRequest;
import cn.schoolwow.workflow.domain.task.WorkFlowTaskResponse;
import cn.schoolwow.workflow.entity.WorkFlowInstance;
import cn.schoolwow.workflow.entity.WorkFlowNode;
import cn.schoolwow.workflow.entity.WorkFlowTask;
import cn.schoolwow.workflow.module.instance.flow.start.ExecuteAfterInstanceFinishListenerFlow;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class InsertWorkFlowTaskFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        WorkFlowNode nextNode = (WorkFlowNode) flowContext.checkData("nextNode");

        flowContext.putData("instanceFinished", false);
        switch (nextNode.getType()){
            case 0:{}break;
            case 1:{
                setAssigner(flowContext);
                insertWorkFlowTask(flowContext);
                setWorkFlowTaskResponse(flowContext);
            }break;
            case 2:{
                flowContext.executeFlowList(new ExecuteAfterInstanceFinishListenerFlow());
                flowContext.putData("instanceFinished", true);
            }break;
        }
    }

    @Override
    public String name() {
        return "添加工作流实例任务";
    }

    private void setAssigner(FlowContext flowContext){
        WorkFlowNode nextNode = (WorkFlowNode) flowContext.checkData("nextNode");
        WorkFlowInstance workFlowInstance = (WorkFlowInstance) flowContext.checkData("workFlowInstance");
        StartWorkFlowRequest startWorkFlowRequest = (StartWorkFlowRequest) flowContext.getData("startWorkFlowRequest");

        if(null!=startWorkFlowRequest&&StringUtils.isNotBlank(startWorkFlowRequest.initiator)){
            flowContext.putCurrentFlowData("assigner", startWorkFlowRequest.initiator);
            return;
        }
        String assigner = nextNode.getAssigner();
        if(assigner.startsWith("{{")&&assigner.endsWith("}}")){
            String name = assigner.substring(2,assigner.length()-2);
            assigner = workFlowInstance.getContextData().getString(name);
        }
        flowContext.putCurrentFlowData("assigner", assigner);
    }

    private void insertWorkFlowTask(FlowContext flowContext){
        Transaction transaction = (Transaction) flowContext.checkData("transaction");
        WorkFlowInstance workFlowInstance = (WorkFlowInstance) flowContext.checkData("workFlowInstance");
        WorkFlowNode nextNode = (WorkFlowNode) flowContext.checkData("nextNode");
        String assigner = (String) flowContext.checkData("assigner");

        WorkFlowTask workFlowTask = new WorkFlowTask();
        workFlowTask.setInstanceId(workFlowInstance.getId());
        workFlowTask.setNodeId(nextNode.getId());
        workFlowTask.setAssigner(assigner);

        transaction.updateType(UpdateType.UpdateByUniqueKey).save(workFlowTask);
        Validate.isTrue(workFlowTask.getId()>0, "获取工作流任务自增id失败!");
        flowContext.putTemporaryData("insertTaskId", workFlowTask.getId());
    }

    private void setWorkFlowTaskResponse(FlowContext flowContext){
        WorkFlowInstance workFlowInstance = (WorkFlowInstance) flowContext.checkData("workFlowInstance");
        WorkFlowNode nextNode = (WorkFlowNode) flowContext.checkData("nextNode");
        long insertTaskId = (long) flowContext.checkData("insertTaskId");
        String definitionName = (String) flowContext.checkData("definitionName");

        WorkFlowTaskResponse workFlowTaskResponse = new WorkFlowTaskResponse();
        workFlowTaskResponse.instanceId = workFlowInstance.getId();
        workFlowTaskResponse.definitionId = workFlowInstance.getDefinitionId();
        workFlowTaskResponse.definitionName = definitionName;
        workFlowTaskResponse.taskId = insertTaskId;
        workFlowTaskResponse.taskName = nextNode.getName();
        workFlowTaskResponse.contextData = workFlowInstance.getContextData();
        workFlowTaskResponse.complete = false;
        flowContext.putTemporaryData("workFlowTaskResponse", workFlowTaskResponse);
    }
}
