package cn.schoolwow.workflow.module.instance.service.query;

import cn.schoolwow.quickdao.domain.DAO;
import cn.schoolwow.quickdao.domain.database.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.database.dql.response.PageVo;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.domain.instance.WorkFlowInstanceQuery;
import cn.schoolwow.workflow.entity.WorkFlowInstance;

import java.util.Set;

public class GetWorkFlowInstancePagingListFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DAO dao = (DAO) flowContext.checkData("dao");

        WorkFlowInstanceQuery workFlowInstanceQuery = (WorkFlowInstanceQuery) flowContext.checkData("workFlowInstanceQuery");
        int pageNumber = (int) flowContext.getData("pageNumber", 1);
        int pageSize = (int) flowContext.getData("pageSize", 10);

        Condition condition = dao.query(WorkFlowInstance.class)
                .page(pageNumber, pageSize);
        if(null!=workFlowInstanceQuery.workFlowInstanceId){
            condition.addQuery("id", workFlowInstanceQuery.workFlowInstanceId);
        }
        if(null!=workFlowInstanceQuery.initiator){
            condition.addQuery("initiator", workFlowInstanceQuery.initiator);
        }
        if(null!=workFlowInstanceQuery.finished){
            condition.addQuery("finished", workFlowInstanceQuery.finished);
        }
        Set<String> keySet = workFlowInstanceQuery.contextDataQuery.keySet();
        for(String key:keySet){
            String value = workFlowInstanceQuery.contextDataQuery.getString(key);
            condition.addRawQuery("context_data->>'"+key+"' = ?", value);
        }
        PageVo<WorkFlowInstance> pageVo = condition
                .execute()
                .getPagingList();
        flowContext.putTemporaryData("pageVo", pageVo);
    }

    @Override
    public String name() {
        return "查询工作流实例";
    }

}
