package cn.schoolwow.workflow.module.instance.service.query;

import cn.schoolwow.quickdao.domain.DAO;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.domain.instance.InstanceContextDataRequest;
import cn.schoolwow.workflow.entity.WorkFlowInstance;
import cn.schoolwow.workflow.entity.WorkFlowTask;
import com.alibaba.fastjson.JSONObject;

public class GetInstanceContextDataFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DAO dao = (DAO) flowContext.checkData("dao");
        InstanceContextDataRequest contextDataRequest = (InstanceContextDataRequest) flowContext.checkData("contextDataRequest");

        Long workFlowInstanceId = contextDataRequest.workFlowInstanceId;
        if(null==workFlowInstanceId){
            workFlowInstanceId = dao.query(WorkFlowTask.class)
                    .addQuery("id", contextDataRequest.workFlowTaskId)
                    .addColumn("instanceId")
                    .execute()
                    .getSingleColumn(Long.class);
        }

        JSONObject contextData = dao.query(WorkFlowInstance.class)
                .addColumn("contextData")
                .addQuery("id", workFlowInstanceId)
                .execute()
                .getSingleColumn(JSONObject.class);
        flowContext.putTemporaryData("contextData", contextData);
    }

    @Override
    public String name() {
        return "获取工作流实例上下文数据";
    }
}
