package cn.schoolwow.workflow.module.instance.service.action;

import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import cn.schoolwow.workflow.module.instance.flow.start.CheckStartWorkFlowRequestFlow;
import cn.schoolwow.workflow.module.instance.flow.start.ExecuteAfterInstanceCreateListenerFlow;
import cn.schoolwow.workflow.module.instance.flow.start.InsertWorkFlowInstance;
import cn.schoolwow.workflow.module.instance.flow.start.QueryWorkFlowDefinitionFlow;
import cn.schoolwow.workflow.module.parent.flow.InsertWorkFlowTaskFlow;
import cn.schoolwow.workflow.module.parent.handler.TransactionTryCatchFinallyHandler;
import cn.schoolwow.workflow.module.task.flow.listener.ExecuteAfterTaskCreateListenerFlow;

public class StartWorkFlowCompositeBusiness implements CompositeBusinessFlow {
    @Override
    public void executeCompositeBusiness(QuickFlowExecutor quickFlowExecutor) {
        quickFlowExecutor.next(new CheckStartWorkFlowRequestFlow())
                .next(new QueryWorkFlowDefinitionFlow())
                .next(new CompositeBusinessFlow() {
                    @Override
                    public void executeCompositeBusiness(QuickFlowExecutor quickFlowExecutor) {
                        quickFlowExecutor.tryCatchFinallyHandler(new TransactionTryCatchFinallyHandler())
                                .next(new InsertWorkFlowInstance())
                                .next(new ExecuteAfterInstanceCreateListenerFlow())
                                .next(new InsertWorkFlowTaskFlow())
                                .next(new ExecuteAfterTaskCreateListenerFlow());
                    }

                    @Override
                    public String name() {
                        return "启动工作流实例-插入记录";
                    }
                });
    }

    @Override
    public String name() {
        return "启动工作流实例";
    }
}
