package cn.schoolwow.workflow.module.instance.kit;

import cn.schoolwow.quickdao.domain.database.dql.response.PageVo;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.workflow.domain.instance.InstanceContextDataRequest;
import cn.schoolwow.workflow.domain.instance.StartWorkFlowRequest;
import cn.schoolwow.workflow.domain.instance.WorkFlowInstanceQuery;
import cn.schoolwow.workflow.entity.WorkFlowInstance;
import cn.schoolwow.workflow.module.instance.service.action.RevokeWorkFlowInstanceCompositeBusiness;
import cn.schoolwow.workflow.module.instance.service.action.StartWorkFlowCompositeBusiness;
import cn.schoolwow.workflow.module.instance.service.query.GetInstanceContextDataFlow;
import cn.schoolwow.workflow.module.instance.service.query.GetWorkFlowInstancePagingListFlow;
import cn.schoolwow.workflow.module.parent.domain.QuickWorkFlowConfig;
import com.alibaba.fastjson.JSONObject;

public class WorkFlowInstanceServiceImpl implements WorkFlowInstanceService {
    private QuickWorkFlowConfig quickWorkFlowConfig;

    public WorkFlowInstanceServiceImpl(QuickWorkFlowConfig quickWorkFlowConfig) {
        this.quickWorkFlowConfig = quickWorkFlowConfig;
    }

    @Override
    public WorkFlowInstance getWorkFlowInstance(WorkFlowInstanceQuery workFlowInstanceQuery) {
        PageVo<WorkFlowInstance> pageVo = getWorkFlowInstancePagingList(workFlowInstanceQuery,1,10);
        if(!pageVo.getList().isEmpty()){
            return pageVo.getList().get(0);
        }
        return null;
    }

    @Override
    public PageVo<WorkFlowInstance> getWorkFlowInstancePagingList(WorkFlowInstanceQuery workFlowInstanceQuery, int pageNumber, int pageSize) {
        FlowContext flowContext = quickWorkFlowConfig.workflow.startFlow(new GetWorkFlowInstancePagingListFlow())
                .putCurrentCompositeFlowData("workFlowInstanceQuery", workFlowInstanceQuery)
                .putCurrentCompositeFlowData("pageNumber", pageNumber)
                .putCurrentCompositeFlowData("pageSize", pageSize)
                .execute();
        PageVo<WorkFlowInstance> pageVo = (PageVo<WorkFlowInstance>) flowContext.checkData("pageVo");
        return pageVo;
    }

    @Override
    public JSONObject getWorkFlowInstanceContextData(InstanceContextDataRequest contextDataRequest){
        FlowContext flowContext = quickWorkFlowConfig.workflow.startFlow(new GetInstanceContextDataFlow())
                .putCurrentCompositeFlowData("contextDataRequest", contextDataRequest)
                .execute();
        JSONObject contextData = (JSONObject) flowContext.getData("contextData");
        return contextData;
    }

    @Override
    public WorkFlowInstance startWorkFlow(String name){
        StartWorkFlowRequest startWorkFlowRequest = new StartWorkFlowRequest();
        startWorkFlowRequest.name = name;
        return startWorkFlow(startWorkFlowRequest);
    }

    @Override
    public WorkFlowInstance startWorkFlow(StartWorkFlowRequest startWorkFlowRequest) {
        FlowContext flowContext = quickWorkFlowConfig.workflow.startFlow(new StartWorkFlowCompositeBusiness())
                .putCurrentCompositeFlowData("startWorkFlowRequest", startWorkFlowRequest)
                .execute();
        WorkFlowInstance workFlowInstance = (WorkFlowInstance) flowContext.checkData("workFlowInstance");
        return workFlowInstance;
    }

    @Override
    public void revokeWorkFlowInstance(long workFlowInstanceId) {
        quickWorkFlowConfig.workflow.startFlow(new RevokeWorkFlowInstanceCompositeBusiness())
                .putCurrentCompositeFlowData("workFlowInstanceId", workFlowInstanceId)
                .execute();
    }
}
