package cn.schoolwow.workflow.module.instance.kit;

import cn.schoolwow.quickdao.domain.database.dql.response.PageVo;
import cn.schoolwow.workflow.domain.instance.InstanceContextDataRequest;
import cn.schoolwow.workflow.domain.instance.StartWorkFlowRequest;
import cn.schoolwow.workflow.domain.instance.WorkFlowInstanceQuery;
import cn.schoolwow.workflow.entity.WorkFlowInstance;
import com.alibaba.fastjson.JSONObject;

public interface WorkFlowInstanceService {
    /**
     * 查询单个工作流实例
     * */
    WorkFlowInstance getWorkFlowInstance(WorkFlowInstanceQuery workFlowInstanceQuery);

    /**
     * 查询工作流实例
     * */
    PageVo<WorkFlowInstance> getWorkFlowInstancePagingList(WorkFlowInstanceQuery workFlowInstanceQuery, int pageNumber, int pageSize);

    /**
     * 查询工作流实例上下文数据
     * @param contextDataRequest 查询请求
     * */
    JSONObject getWorkFlowInstanceContextData(InstanceContextDataRequest contextDataRequest);

    /**
     * 启动工作流实例
     * @param name 工作流定义名称
     * */
    WorkFlowInstance startWorkFlow(String name);

    /**
     * 启动工作流实例
     * @param startWorkFlowRequest 启动工作流请求
     * */
    WorkFlowInstance startWorkFlow(StartWorkFlowRequest startWorkFlowRequest);

    /**
     * 撤销工作流实例
     * @param workFlowInstanceId 工作流实例id
     * */
    void revokeWorkFlowInstance(long workFlowInstanceId);
}
