package cn.schoolwow.workflow.module.instance.flow.start;

import cn.schoolwow.quickdao.domain.DAO;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.domain.instance.StartWorkFlowRequest;
import cn.schoolwow.workflow.entity.WorkFlowDefinition;
import cn.schoolwow.workflow.entity.WorkFlowNode;
import cn.schoolwow.workflow.module.parent.flow.SetNextNodeFlow;
import org.apache.commons.lang3.Validate;

public class QueryWorkFlowDefinitionFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        getWorkFlowDefinition(flowContext);
        getStartWorkFlowNode(flowContext);
        setNextNode(flowContext);
    }

    @Override
    public String name() {
        return "启动工作流实例-查询工作流定义信息";
    }

    private void getWorkFlowDefinition(FlowContext flowContext){
        DAO dao = (DAO) flowContext.checkData("dao");
        StartWorkFlowRequest startWorkFlowRequest = (StartWorkFlowRequest) flowContext.checkData("startWorkFlowRequest");

        WorkFlowDefinition workFlowDefinition = dao.query(WorkFlowDefinition.class)
                .addQuery("name", startWorkFlowRequest.name)
                .execute()
                .getOne();
        Validate.notNull(workFlowDefinition, "流程定义未部署!流程名称:"+startWorkFlowRequest.name);
        flowContext.putTemporaryData("workFlowDefinition", workFlowDefinition);
    }

    private void getStartWorkFlowNode(FlowContext flowContext){
        DAO dao = (DAO) flowContext.checkData("dao");
        WorkFlowDefinition workFlowDefinition = (WorkFlowDefinition) flowContext.checkData("workFlowDefinition");

        WorkFlowNode startNode = dao.query(WorkFlowNode.class)
                .addQuery("definitionId", workFlowDefinition.getId())
                .addQuery("type", 0)
                .execute()
                .getOne();
        flowContext.putTemporaryData("startNode", startNode);
    }

    private void setNextNode(FlowContext flowContext){
        WorkFlowDefinition workFlowDefinition = (WorkFlowDefinition) flowContext.checkData("workFlowDefinition");
        WorkFlowNode startNode = (WorkFlowNode) flowContext.checkData("startNode");

        flowContext.startFlow(new SetNextNodeFlow())
                .putCurrentCompositeFlowData("definitionId", workFlowDefinition.getId())
                .putCurrentCompositeFlowData("currentWorkflowNode", startNode)
                .execute();
    }

}
