package cn.schoolwow.workflow.module.instance.flow.start;

import cn.schoolwow.quickdao.domain.transaction.Transaction;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.domain.instance.StartWorkFlowRequest;
import cn.schoolwow.workflow.entity.WorkFlowDefinition;
import cn.schoolwow.workflow.entity.WorkFlowInstance;
import cn.schoolwow.workflow.entity.WorkFlowNode;

public class InsertWorkFlowInstance implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Transaction transaction = (Transaction) flowContext.checkData("transaction");
        WorkFlowDefinition workFlowDefinition = (WorkFlowDefinition) flowContext.checkData("workFlowDefinition");
        WorkFlowNode nextNode = (WorkFlowNode) flowContext.checkData("nextNode");
        StartWorkFlowRequest startWorkFlowRequest = (StartWorkFlowRequest) flowContext.checkData("startWorkFlowRequest");

        WorkFlowInstance workFlowInstance = new WorkFlowInstance();
        workFlowInstance.setDefinitionId(workFlowDefinition.getId());
        workFlowInstance.setWorkFlowNodeId(nextNode.getId());
        workFlowInstance.setInitiator(startWorkFlowRequest.initiator);
        workFlowInstance.setContextData(startWorkFlowRequest.contextData);
        transaction.insert(workFlowInstance);

        flowContext.putTemporaryData("workFlowInstance", workFlowInstance);
    }

    @Override
    public String name() {
        return "启动工作流实例-插入工作流程实例记录";
    }
}
