package cn.schoolwow.workflow.module.instance.flow.start;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.entity.WorkFlowInstance;
import cn.schoolwow.workflow.module.parent.domain.QuickWorkFlowOption;

public class ExecuteAfterInstanceFinishListenerFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickWorkFlowOption quickWorkFlowOption = (QuickWorkFlowOption) flowContext.checkData("quickWorkFlowOption");

        if(null==quickWorkFlowOption.workFlowInstanceListener){
            return;
        }
        WorkFlowInstance workFlowInstance = (WorkFlowInstance) flowContext.checkData("workFlowInstance");
        quickWorkFlowOption.workFlowInstanceListener.afterInstanceFinish(workFlowInstance);
    }

    @Override
    public String name() {
        return "工作流实例结束之后";
    }
}
