package cn.schoolwow.workflow.module.instance.flow.start;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.domain.instance.StartWorkFlowRequest;
import org.apache.commons.lang3.Validate;

public class CheckStartWorkFlowRequestFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        StartWorkFlowRequest startWorkFlowRequest = (StartWorkFlowRequest) flowContext.checkData("startWorkFlowRequest");

        Validate.notEmpty(startWorkFlowRequest.name, "流程定义名称不能为空");
        flowContext.putTemporaryData("definitionName", startWorkFlowRequest.name);
    }

    @Override
    public String name() {
        return "检查启动流程实例参数";
    }
}
