package cn.schoolwow.workflow.module.instance.flow.revoke;

import cn.schoolwow.quickdao.domain.DAO;
import cn.schoolwow.quickdao.domain.database.dql.condition.Condition;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.entity.WorkFlowInstance;

public class RevokeWorkFlowInstanceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DAO dao = (DAO) flowContext.checkData("dao");
        long workFlowInstanceId = (long) flowContext.checkData("workFlowInstanceId");

        Condition condition = dao.query(WorkFlowInstance.class)
                .addQuery("id", workFlowInstanceId);
        WorkFlowInstance workFlowInstance = (WorkFlowInstance) condition.clone().execute().getOne();
        flowContext.putTemporaryData("workFlowInstance", workFlowInstance);

        condition.clone().addUpdate("finished", true)
                .execute()
                .update();
    }

    @Override
    public String name() {
        return "撤销工作流实例";
    }
}
