package cn.schoolwow.workflow.module.definition.service.query;

import cn.schoolwow.quickdao.domain.DAO;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.entity.WorkFlowDefinition;

import java.util.List;

public class GetWorkFlowDefinitionListFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DAO dao = (DAO) flowContext.checkData("dao");

        List<WorkFlowDefinition> workFlowDefinitionList = dao.query(WorkFlowDefinition.class)
                .execute()
                .getList();
        flowContext.putTemporaryData("workFlowDefinitionList", workFlowDefinitionList);
    }

    @Override
    public String name() {
        return "查询工作流定义列表";
    }
}
