package cn.schoolwow.workflow.module.definition.service.deploy;

import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import cn.schoolwow.workflow.module.definition.flow.deploy.ParseInputStreamFlow;
import cn.schoolwow.workflow.module.definition.flow.deploy.check.CheckDeployWorkArrayFlow;
import cn.schoolwow.workflow.module.definition.flow.deploy.check.CheckWorkFlowDeployExistFlow;
import cn.schoolwow.workflow.module.definition.flow.deploy.insert.InsertWorkFlowDefinitionFlow;
import cn.schoolwow.workflow.module.definition.flow.deploy.insert.InsertWorkFlowJumpFlow;
import cn.schoolwow.workflow.module.definition.flow.deploy.insert.InsertWorkFlowNodeFlow;
import cn.schoolwow.workflow.module.parent.handler.TransactionTryCatchFinallyHandler;

public class DeployWorkFlowCompositeBusiness implements CompositeBusinessFlow {
    @Override
    public void executeCompositeBusiness(QuickFlowExecutor quickFlowExecutor) {
        quickFlowExecutor.next(new CheckWorkFlowDeployExistFlow())
                .next(new ParseInputStreamFlow())
                .next(new CheckDeployWorkArrayFlow())
                .next(new CompositeBusinessFlow() {
                    @Override
                    public void executeCompositeBusiness(QuickFlowExecutor quickFlowExecutor) {
                        quickFlowExecutor.tryCatchFinallyHandler(new TransactionTryCatchFinallyHandler())
                                .next(new InsertWorkFlowDefinitionFlow())
                                .next(new InsertWorkFlowNodeFlow())
                                .next(new InsertWorkFlowJumpFlow());
                    }

                    @Override
                    public String name() {
                        return "部署工作流-插入数据库记录";
                    }
                });
    }

    @Override
    public String name() {
        return "部署工作流";
    }
}
