package cn.schoolwow.workflow.module.definition.kit;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.workflow.entity.WorkFlowDefinition;
import cn.schoolwow.workflow.module.definition.service.deploy.DeployWorkFlowCompositeBusiness;
import cn.schoolwow.workflow.module.definition.service.query.GetWorkFlowDefinitionListFlow;
import cn.schoolwow.workflow.module.definition.service.query.HasDeployWorkFlowFlow;
import cn.schoolwow.workflow.module.parent.domain.QuickWorkFlowConfig;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class WorkFlowDeployImpl implements WorkFlowDeploy{
    private QuickWorkFlowConfig quickWorkFlowConfig;

    public WorkFlowDeployImpl(QuickWorkFlowConfig quickWorkFlowConfig) {
        this.quickWorkFlowConfig = quickWorkFlowConfig;
    }

    @Override
    public List<WorkFlowDefinition> getWorkFlowDefinitionList(){
        FlowContext flowContext = quickWorkFlowConfig.workflow.startFlow(new GetWorkFlowDefinitionListFlow())
                .execute();
        List<WorkFlowDefinition> workFlowDefinitionList = (List<WorkFlowDefinition>) flowContext.getData("workFlowDefinitionList", new ArrayList<>());
        return workFlowDefinitionList;
    }

    @Override
    public boolean hasDeploy(String name) {
        FlowContext flowContext = quickWorkFlowConfig.workflow.startFlow(new HasDeployWorkFlowFlow())
                .putCurrentCompositeFlowData("name", name)
                .execute();
        boolean exist = (boolean) flowContext.checkData("exist");
        return exist;
    }

    @Override
    public void deployWorkFlow(String name, InputStream inputStream) {
        quickWorkFlowConfig.workflow.startFlow(new DeployWorkFlowCompositeBusiness())
                .putCurrentCompositeFlowData("name", name)
                .putCurrentCompositeFlowData("inputStream", inputStream)
                .execute();
    }
}
