package cn.schoolwow.workflow.module.definition.kit;

import cn.schoolwow.workflow.entity.WorkFlowDefinition;

import java.io.InputStream;
import java.util.List;

public interface WorkFlowDeploy {
    /**
     * 查询工作流定义列表
     * */
    List<WorkFlowDefinition> getWorkFlowDefinitionList();

    /**
     * 判断工作流是否已经部署过
     * */
    boolean hasDeploy(String name);

    /**
     * 部署工作流
     * @param name 工作流名称
     * @param inputStream JSON文件数据流
     * */
    void deployWorkFlow(String name, InputStream inputStream);
}
