package cn.schoolwow.workflow.module.definition.flow.deploy.insert;

import cn.schoolwow.quickdao.domain.transaction.Transaction;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.entity.WorkFlowNode;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class InsertWorkFlowNodeFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        JSONObject workflow = (JSONObject) flowContext.checkData("workflow");
        Transaction transaction = (Transaction) flowContext.checkData("transaction");
        long workFlowDefinitionId = (long) flowContext.checkData("workFlowDefinitionId");

        List<WorkFlowNode> workFlowNodeList = new ArrayList<>();
        JSONArray nodes = workflow.getJSONArray("nodes");
        for(int i=0;i<nodes.size();i++){
            JSONObject node = nodes.getJSONObject(i);

            WorkFlowNode workFlowNode = new WorkFlowNode();
            workFlowNode.setDefinitionId(workFlowDefinitionId);
            workFlowNode.setName(node.getString("name"));
            workFlowNode.setType(node.getInteger("type"));
            workFlowNode.setAssigner(node.getString("assigner"));
            workFlowNodeList.add(workFlowNode);
        }
        transaction.insert(workFlowNodeList);
        flowContext.putCurrentCompositeFlowData("workFlowNodeList", workFlowNodeList);
    }

    @Override
    public String name() {
        return "部署工作流-插入节点定义表";
    }
}
