package cn.schoolwow.workflow.module.definition.flow.deploy.insert;

import cn.schoolwow.quickdao.domain.transaction.Transaction;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.entity.WorkFlowNode;
import cn.schoolwow.workflow.entity.WorkFlowNodeJump;
import cn.schoolwow.workflow.util.InstanceFilterUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;

import java.util.ArrayList;
import java.util.List;

public class InsertWorkFlowJumpFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        JSONObject workflow = (JSONObject) flowContext.checkData("workflow");
        Transaction transaction = (Transaction) flowContext.checkData("transaction");
        List<WorkFlowNode> workFlowNodeList = (List<WorkFlowNode>) flowContext.checkData("workFlowNodeList");
        long workFlowDefinitionId = (long) flowContext.checkData("workFlowDefinitionId");

        List<WorkFlowNodeJump> workFlowNodeJumpList = new ArrayList<>();
        JSONArray jumpArray = workflow.getJSONArray("jumpArray");
        for(int i=0;i<jumpArray.size();i++){
            JSONObject jump = jumpArray.getJSONObject(i);
            WorkFlowNodeJump workFlowNodeJump = new WorkFlowNodeJump();
            workFlowNodeJump.setDefinitionId(workFlowDefinitionId);
            {
                String current = jump.getString("current");
                WorkFlowNode workFlowNode = InstanceFilterUtil.filterByFieldValue(workFlowNodeList, "name", current);
                Validate.notNull(workFlowNode, "跳转节点不存在!节点名称:"+current);
                workFlowNodeJump.setCurrentNodeId(workFlowNode.getId());
            }
            {
                String next = jump.getString("next");
                WorkFlowNode workFlowNode = InstanceFilterUtil.filterByFieldValue(workFlowNodeList, "name", next);
                Validate.notNull(workFlowNode, "跳转节点不存在!节点名称:"+next);
                workFlowNodeJump.setNextNodeId(workFlowNode.getId());
            }
            workFlowNodeJump.setCondition(jump.getInteger("condition"));
            workFlowNodeJumpList.add(workFlowNodeJump);
        }
        transaction.insert(workFlowNodeJumpList);
        flowContext.putCurrentCompositeFlowData("workFlowNodeJumpList", workFlowNodeJumpList);
    }

    @Override
    public String name() {
        return "部署工作流-插入工作流节点跳转表";
    }
}
