package cn.schoolwow.workflow.module.definition.flow.deploy.insert;

import cn.schoolwow.quickdao.domain.transaction.Transaction;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.entity.WorkFlowDefinition;
import org.apache.commons.lang3.Validate;

public class InsertWorkFlowDefinitionFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String name = (String) flowContext.checkData("name");
        Transaction transaction = (Transaction) flowContext.checkData("transaction");

        WorkFlowDefinition workFlowDefinition = new WorkFlowDefinition();
        workFlowDefinition.setName(name);
        transaction.insert(workFlowDefinition);
        Validate.isTrue(workFlowDefinition.getId()>0, "获取工作流定义自增id失败");
        flowContext.putCurrentCompositeFlowData("workFlowDefinitionId", workFlowDefinition.getId());
    }

    @Override
    public String name() {
        return "部署工作流-插入工作流定义表";
    }
}
