package cn.schoolwow.workflow.module.definition.flow.deploy.check;

import cn.schoolwow.quickdao.domain.DAO;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.entity.WorkFlowDefinition;

public class CheckWorkFlowDeployExistFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DAO dao = (DAO) flowContext.checkData("dao");
        String name = (String) flowContext.checkData("name");

        long count = dao.query(WorkFlowDefinition.class)
                .addQuery("name", name)
                .execute()
                .count();
        if(count>0){
            throw new IllegalArgumentException("该流程已经部署过!名称:"+name);
        }
    }

    @Override
    public String name() {
        return "检查工作流定义是否已经存在";
    }
}
