package cn.schoolwow.workflow.module.definition.flow.deploy.check;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;

import java.util.HashSet;
import java.util.Set;

public class CheckNodeConnectivityFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        checkNodeName(flowContext);
        checkStartAndEndNode(flowContext);
        checkStartNodeJumpSize(flowContext);
    }

    @Override
    public String name() {
        return "检查工作流节点连通完成性";
    }

    private void checkNodeName(FlowContext flowContext){
        JSONObject workflow = (JSONObject) flowContext.checkData("workflow");

        Set<String> nodeNameSet = new HashSet<>();
        {
            JSONArray nodes = workflow.getJSONArray("nodes");
            for(int i=0;i<nodes.size();i++){
                JSONObject node = nodes.getJSONObject(i);

                String nodeName = node.getString("name");
                Validate.notEmpty(nodeName, "节点名称不能为空");
                nodeNameSet.add(nodeName);
            }
        }
        {
            JSONArray jumpArray = workflow.getJSONArray("jumpArray");
            for(int i=0;i<jumpArray.size();i++){
                JSONObject jump = jumpArray.getJSONObject(i);
                String current = jump.getString("current");
                if(!nodeNameSet.contains(current)){
                    throw new IllegalArgumentException("未定义的当前节点名称!节点名称:"+current);
                }
                String next = jump.getString("next");
                if(!nodeNameSet.contains(next)){
                    throw new IllegalArgumentException("未定义的下一节点名称!节点名称:"+next);
                }
            }
        }
    }

    private void checkStartAndEndNode(FlowContext flowContext){
        JSONObject workflow = (JSONObject) flowContext.checkData("workflow");

        JSONArray nodes = workflow.getJSONArray("nodes");
        int countOfStart = 0, countOfEnd = 0;
        for(int i=0;i<nodes.size();i++){
            JSONObject node = nodes.getJSONObject(i);

            Integer type = node.getInteger("type");
            Validate.notNull(type, "节点类型不能为空");

            switch (type){
                case 0:{
                    countOfStart++;
                    flowContext.putCurrentFlowData("startNodeName", node.getString("name"));
                }break;
                case 2:{
                    countOfEnd++;
                    flowContext.putCurrentFlowData("endNodeName", node.getString("name"));
                }break;
            }
        }
        if(countOfStart!=1){
            throw new IllegalArgumentException("开始节点只能有一个!实际开始节点个数:"+countOfStart);
        }
        if(countOfEnd!=1){
            throw new IllegalArgumentException("结束节点只能有一个!实际结束节点个数:"+countOfEnd);
        }
    }

    private void checkStartNodeJumpSize(FlowContext flowContext){
        JSONObject workflow = (JSONObject) flowContext.checkData("workflow");
        String startNodeName = (String) flowContext.checkData("startNodeName");

        JSONArray jumpArray = workflow.getJSONArray("jumpArray");
        int startNodeJumpSize = 0;
        for(int i=0;i<jumpArray.size();i++) {
            JSONObject jump = jumpArray.getJSONObject(i);

            if(startNodeName.equalsIgnoreCase(jump.getString("current"))){
                startNodeJumpSize++;
            }
        }
        if(startNodeJumpSize!=1){
            throw new IllegalArgumentException("开始节点只能连接一条线!实际开始节点连接个数:"+startNodeJumpSize);
        }
    }
}
