package cn.schoolwow.workflow.module.definition.flow.deploy;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.io.IOUtils;

import java.io.InputStream;

public class ParseInputStreamFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        InputStream inputStream = (InputStream) flowContext.checkData("inputStream");

        String content = IOUtils.toString(inputStream, "UTF-8");
        JSONObject workflow = JSONObject.parseObject(content);
        flowContext.putTemporaryData("workflow", workflow);
    }

    @Override
    public String name() {
        return "部署工作流-解析输入流";
    }
}
