package cn.schoolwow.workflow.entity;

import cn.schoolwow.quickdao.annotation.*;

import java.time.LocalDateTime;

@Comment("工作流任务列表")
@CompositeIndex(columns = {"instanceId", "nodeId"})
public class WorkFlowTask {
    @Id
    private long id;

    @Comment("工作流实例id")
    @Constraint(notNull = true)
    @ForeignKey(table = WorkFlowInstance.class)
    private long instanceId;

    @Comment("节点id")
    @Constraint(notNull = true)
    @ForeignKey(table = WorkFlowNode.class)
    private long nodeId;

    @Comment("分配人")
    private String assigner;

    @Comment("是否已完成")
    @Constraint(notNull = true)
    private boolean complete;

    @TableField(createdAt = true)
    private LocalDateTime createdAt;

    @TableField(updatedAt = true)
    private LocalDateTime updatedAt;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(long instanceId) {
        this.instanceId = instanceId;
    }

    public long getNodeId() {
        return nodeId;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public String getAssigner() {
        return assigner;
    }

    public void setAssigner(String assigner) {
        this.assigner = assigner;
    }

    public boolean isComplete() {
        return complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public LocalDateTime getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }
}
