package cn.schoolwow.workflow.entity;

import cn.schoolwow.quickdao.annotation.*;

import java.time.LocalDateTime;

@Comment("工作流节点跳转关系")
@CompositeIndex(columns = {"definitionId", "currentNodeId", "nextNodeId"})
public class WorkFlowNodeJump {
    @Id
    private long id;

    @Comment("工作流定义id")
    @Constraint(notNull = true)
    @ForeignKey(table = WorkFlowDefinition.class)
    private long definitionId;

    @Comment("当前节点id")
    @Constraint(notNull = true)
    @ForeignKey(table = WorkFlowNode.class)
    private long currentNodeId;

    @Comment("下一个节点id")
    @Constraint(notNull = true)
    @ForeignKey(table = WorkFlowNode.class)
    private long nextNodeId;

    @Comment("跳转条件(0:完成任务,1:拒绝任务)")
    private Integer condition;

    @TableField(createdAt = true)
    private LocalDateTime createdAt;

    @TableField(updatedAt = true)
    private LocalDateTime updatedAt;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getDefinitionId() {
        return definitionId;
    }

    public void setDefinitionId(long definitionId) {
        this.definitionId = definitionId;
    }

    public long getCurrentNodeId() {
        return currentNodeId;
    }

    public void setCurrentNodeId(long currentNodeId) {
        this.currentNodeId = currentNodeId;
    }

    public long getNextNodeId() {
        return nextNodeId;
    }

    public void setNextNodeId(long nextNodeId) {
        this.nextNodeId = nextNodeId;
    }

    public Integer getCondition() {
        return condition;
    }

    public void setCondition(Integer condition) {
        this.condition = condition;
    }

    public LocalDateTime getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }
}
