package cn.schoolwow.workflow.entity;

import cn.schoolwow.quickdao.annotation.*;

import java.time.LocalDateTime;

@Comment("工作流节点")
@CompositeIndex(columns = {"definitionId", "name"})
public class WorkFlowNode {
    @Id
    private long id;

    @Comment("工作流定义id")
    @Constraint(notNull = true)
    @ForeignKey(table = WorkFlowDefinition.class)
    private long definitionId;

    @Comment("节点名称")
    @Constraint(notNull = true)
    private String name;

    @Comment("节点类型(0:开始节点,1:中间节点,2:结束节点)")
    @Constraint(notNull = true)
    private Integer type;

    @Comment("分配人")
    private String assigner;

    @TableField(createdAt = true)
    private LocalDateTime createdAt;

    @TableField(updatedAt = true)
    private LocalDateTime updatedAt;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getDefinitionId() {
        return definitionId;
    }

    public void setDefinitionId(long definitionId) {
        this.definitionId = definitionId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getAssigner() {
        return assigner;
    }

    public void setAssigner(String assigner) {
        this.assigner = assigner;
    }

    public LocalDateTime getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }
}
