package cn.schoolwow.workflow.entity;

import cn.schoolwow.quickdao.annotation.*;
import com.alibaba.fastjson.JSONObject;

import java.time.LocalDateTime;

@Comment("工作流实例")
public class WorkFlowInstance {
    @Id
    private long id;

    @Comment("关联工作流定义")
    @ForeignKey(table = WorkFlowDefinition.class)
    @Constraint(notNull = true)
    private long definitionId;

    @Comment("当前节点")
    @ForeignKey(table = WorkFlowNode.class)
    @Constraint(notNull = true)
    private long workFlowNodeId;

    @Comment("流程发起人")
    private String initiator;

    @Comment("实例上下文数据")
    private JSONObject contextData;

    @Comment("实例是否已结束")
    @Constraint(notNull = true)
    private boolean finished;

    @TableField(createdAt = true)
    private LocalDateTime createdAt;

    @TableField(updatedAt = true)
    private LocalDateTime updatedAt;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getDefinitionId() {
        return definitionId;
    }

    public void setDefinitionId(long definitionId) {
        this.definitionId = definitionId;
    }

    public long getWorkFlowNodeId() {
        return workFlowNodeId;
    }

    public void setWorkFlowNodeId(long workFlowNodeId) {
        this.workFlowNodeId = workFlowNodeId;
    }

    public String getInitiator() {
        return initiator;
    }

    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }

    public JSONObject getContextData() {
        return contextData;
    }

    public void setContextData(JSONObject contextData) {
        this.contextData = contextData;
    }

    public boolean isFinished() {
        return finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public LocalDateTime getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }
}
