package cn.schoolwow.workflow.entity;

import cn.schoolwow.quickdao.annotation.Comment;
import cn.schoolwow.quickdao.annotation.ForeignKey;
import cn.schoolwow.quickdao.annotation.Id;
import cn.schoolwow.quickdao.annotation.TableField;

import java.time.LocalDateTime;

@Comment("工作流操作历史记录")
public class WorkFlowHistory {
    @Id
    private long id;

    @Comment("流程实例")
    @ForeignKey(table = WorkFlowDefinition.class)
    private long workFlowDefinitionId;

    @Comment("流程实例")
    @ForeignKey(table = WorkFlowInstance.class)
    private long workFlowInstanceId;

    @Comment("流程节点")
    private long workFlowNodeId;

    @Comment("完成类型")
    private Integer condition;

    @TableField(createdAt = true)
    private LocalDateTime createdAt;

    @TableField(updatedAt = true)
    private LocalDateTime updatedAt;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getWorkFlowDefinitionId() {
        return workFlowDefinitionId;
    }

    public void setWorkFlowDefinitionId(long workFlowDefinitionId) {
        this.workFlowDefinitionId = workFlowDefinitionId;
    }

    public long getWorkFlowInstanceId() {
        return workFlowInstanceId;
    }

    public void setWorkFlowInstanceId(long workFlowInstanceId) {
        this.workFlowInstanceId = workFlowInstanceId;
    }

    public long getWorkFlowNodeId() {
        return workFlowNodeId;
    }

    public void setWorkFlowNodeId(long workFlowNodeId) {
        this.workFlowNodeId = workFlowNodeId;
    }

    public Integer getCondition() {
        return condition;
    }

    public void setCondition(Integer condition) {
        this.condition = condition;
    }

    public LocalDateTime getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }
}
