package cn.schoolwow.workflow.domain.instance;

import cn.schoolwow.workflow.entity.WorkFlowInstance;

/**工作流实例监听*/
public interface WorkFlowInstanceListener {
    /**
     * 工作流实例创建后
     * @param workFlowInstance 工作流实例
     * */
    void afterInstanceCreate(WorkFlowInstance workFlowInstance);

    /**
     * 工作流实例结束前
     * @param workFlowInstance 工作流实例
     * */
    void beforeInstanceFinish(WorkFlowInstance workFlowInstance);

    /**
     * 工作流实例结束后
     * @param workFlowInstance 工作流实例
     * */
    void afterInstanceFinish(WorkFlowInstance workFlowInstance);

}
