package cn.schoolwow.workflow;

import cn.schoolwow.quickdao.QuickDAO;
import cn.schoolwow.quickdao.domain.DAO;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.QuickFlowBuilder;
import cn.schoolwow.workflow.domain.instance.WorkFlowInstanceListener;
import cn.schoolwow.workflow.domain.task.WorkFlowTaskListener;
import cn.schoolwow.workflow.module.parent.domain.QuickWorkFlowConfig;
import cn.schoolwow.workflow.module.parent.domain.QuickWorkFlowOption;
import cn.schoolwow.workflow.module.parent.kit.WorkFlowInvocationHandler;

import javax.sql.DataSource;
import java.lang.reflect.Proxy;

public class QuickWorkFlowBuilder {
    private DAO dao;

    private QuickWorkFlowOption quickWorkFlowOption = new QuickWorkFlowOption();

    public static QuickWorkFlowBuilder newInstance() {
        return new QuickWorkFlowBuilder();
    }

    public QuickWorkFlowBuilder dataSource(DataSource dataSource){
        DAO dao = QuickDAO.newInstance()
                .dataSource(dataSource)
                .packageName("cn.schoolwow.workflow.entity","workflow")
                .build();
        this.dao = dao;
        return this;
    }

    public QuickWorkFlowBuilder workFlowInstanceListener(WorkFlowInstanceListener workFlowInstanceListener){
        quickWorkFlowOption.workFlowInstanceListener = workFlowInstanceListener;
        return this;
    }

    public QuickWorkFlowBuilder workFlowTaskListener(WorkFlowTaskListener workFlowTaskListener){
        quickWorkFlowOption.workFlowTaskListener = workFlowTaskListener;
        return this;
    }

    public QuickWorkFlow build(){
        if(null==dao){
            throw new IllegalArgumentException("请配置数据库连接池!");
        }
        QuickFlow workflow = QuickFlowBuilder.newInstance()
                .putContextData("dao", dao)
                .putContextData("quickWorkFlowOption", quickWorkFlowOption);
        QuickWorkFlowConfig quickWorkFlowConfig = new QuickWorkFlowConfig();
        quickWorkFlowConfig.workflow = workflow;
        WorkFlowInvocationHandler workFlowInvocationHandler = new WorkFlowInvocationHandler(quickWorkFlowConfig);
        QuickWorkFlow quickWorkFlowProxy = (QuickWorkFlow) Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(),
                new Class<?>[]{QuickWorkFlow.class}, workFlowInvocationHandler);
        return quickWorkFlowProxy;
    }
}
