/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.workflow.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.jar.JarFile;

public class ResourceUtil {
    public static void deleteFile(String directoryPath) throws IOException {
        Files.walkFileTree(Paths.get(directoryPath, new String[0]), (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return null;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.deleteIfExists(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return null;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.deleteIfExists(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static InputStream getInputStreamByPath(String path) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(path);
        if (url == null) {
            throw new IllegalArgumentException("\u8def\u5f84\u4e0d\u5b58\u5728!\u8def\u5f84:" + path);
        }
        try {
            switch (url.getProtocol()) {
                case "file": {
                    File file = new File(url.getFile());
                    FileInputStream fis = new FileInputStream(file);
                    return fis;
                }
                case "jar": {
                    JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                    JarFile jarFile = jarURLConnection.getJarFile();
                    InputStream inputStream = jarFile.getInputStream(jarFile.getJarEntry(path));
                    return inputStream;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8def\u5f84!" + path);
    }
}

