/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.workflow.util;

import cn.schoolwow.workflow.util.ReflectionUtil;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class InstanceFilterUtil {
    public static <T> T filterByFieldValue(List<T> list, String fieldName, Object fieldValue) {
        for (T instance : list) {
            Object actualFieldValue = ReflectionUtil.getInstanceFieldValue(instance, fieldName);
            if (!fieldValue.equals(actualFieldValue)) continue;
            return instance;
        }
        return null;
    }

    public static <T> T filterByMultipleFieldValue(List<T> list, String[] fieldNames, Object[] fieldValues) {
        Validate.isTrue((fieldNames.length == fieldValues.length ? 1 : 0) != 0, (String)("\u5b57\u6bb5\u540d\u548c\u5b57\u6bb5\u503c\u5217\u8868\u957f\u5ea6\u4e0d\u4e00\u81f4!\u5b57\u6bb5\u540d\u957f\u5ea6:" + fieldNames.length + ",\u5b57\u6bb5\u503c\u957f\u5ea6:" + fieldValues.length), (Object[])new Object[0]);
        for (T instance : list) {
            boolean match = true;
            for (int i = 0; i < fieldNames.length; ++i) {
                Object actualFieldValue = ReflectionUtil.getInstanceFieldValue(instance, fieldNames[i]);
                match = match && fieldValues[i].equals(actualFieldValue);
            }
            if (!match) continue;
            return instance;
        }
        return null;
    }
}

