/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.workflow.service.execute;

import cn.schoolwow.quickdao.domain.database.dql.response.PageVo;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import cn.schoolwow.workflow.composite.instance.action.RevokeWorkFlowInstanceCompositeBusiness;
import cn.schoolwow.workflow.composite.instance.action.StartWorkFlowCompositeBusiness;
import cn.schoolwow.workflow.composite.instance.query.GetInstanceContextDataFlow;
import cn.schoolwow.workflow.composite.instance.query.GetWorkFlowInstancePagingListFlow;
import cn.schoolwow.workflow.domain.QuickWorkFlowConfig;
import cn.schoolwow.workflow.domain.request.ContextDataRequest;
import cn.schoolwow.workflow.domain.request.StartWorkFlowRequest;
import cn.schoolwow.workflow.domain.request.WorkFlowInstanceQuery;
import cn.schoolwow.workflow.entity.WorkFlowInstance;
import cn.schoolwow.workflow.service.execute.WorkFlowInstanceService;
import com.alibaba.fastjson.JSONObject;

public class WorkFlowInstanceServiceImpl
implements WorkFlowInstanceService {
    private QuickWorkFlowConfig quickWorkFlowConfig;

    public WorkFlowInstanceServiceImpl(QuickWorkFlowConfig quickWorkFlowConfig) {
        this.quickWorkFlowConfig = quickWorkFlowConfig;
    }

    @Override
    public WorkFlowInstance getWorkFlowInstance(WorkFlowInstanceQuery workFlowInstanceQuery) {
        PageVo<WorkFlowInstance> pageVo = this.getWorkFlowInstancePagingList(workFlowInstanceQuery, 1, 10);
        if (!pageVo.getList().isEmpty()) {
            return (WorkFlowInstance)pageVo.getList().get(0);
        }
        return null;
    }

    @Override
    public PageVo<WorkFlowInstance> getWorkFlowInstancePagingList(WorkFlowInstanceQuery workFlowInstanceQuery, int pageNumber, int pageSize) {
        FlowContext flowContext = this.quickWorkFlowConfig.workflow.startFlow((BusinessFlow)new GetWorkFlowInstancePagingListFlow()).putCurrentCompositeFlowData("workFlowInstanceQuery", (Object)workFlowInstanceQuery).putCurrentCompositeFlowData("pageNumber", (Object)pageNumber).putCurrentCompositeFlowData("pageSize", (Object)pageSize).execute();
        PageVo pageVo = (PageVo)flowContext.checkData("pageVo");
        return pageVo;
    }

    @Override
    public JSONObject getWorkFlowInstanceContextData(ContextDataRequest contextDataRequest) {
        FlowContext flowContext = this.quickWorkFlowConfig.workflow.startFlow((BusinessFlow)new GetInstanceContextDataFlow()).putCurrentCompositeFlowData("contextDataRequest", (Object)contextDataRequest).execute();
        JSONObject contextData = (JSONObject)flowContext.getData("contextData");
        return contextData;
    }

    @Override
    public WorkFlowInstance startWorkFlow(String name) {
        StartWorkFlowRequest startWorkFlowRequest = new StartWorkFlowRequest();
        startWorkFlowRequest.name = name;
        return this.startWorkFlow(startWorkFlowRequest);
    }

    @Override
    public WorkFlowInstance startWorkFlow(StartWorkFlowRequest startWorkFlowRequest) {
        FlowContext flowContext = this.quickWorkFlowConfig.workflow.startFlow((CompositeBusinessFlow)new StartWorkFlowCompositeBusiness()).putCurrentCompositeFlowData("startWorkFlowRequest", (Object)startWorkFlowRequest).execute();
        WorkFlowInstance workFlowInstance = (WorkFlowInstance)flowContext.checkData("workFlowInstance");
        return workFlowInstance;
    }

    @Override
    public void revokeWorkFlowInstance(long workFlowInstanceId) {
        this.quickWorkFlowConfig.workflow.startFlow((CompositeBusinessFlow)new RevokeWorkFlowInstanceCompositeBusiness()).putCurrentCompositeFlowData("workFlowInstanceId", (Object)workFlowInstanceId).execute();
    }
}

