/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.workflow.flow.definition.deploy.check;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import org.apache.commons.lang3.Validate;

public class CheckNodeConnectivityFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.checkNodeName(flowContext);
        this.checkStartAndEndNode(flowContext);
        this.checkStartNodeJumpSize(flowContext);
    }

    public String name() {
        return "\u68c0\u67e5\u5de5\u4f5c\u6d41\u8282\u70b9\u8fde\u901a\u5b8c\u6210\u6027";
    }

    private void checkNodeName(FlowContext flowContext) {
        int i;
        JSONObject workflow = (JSONObject)flowContext.checkData("workflow");
        HashSet<String> nodeNameSet = new HashSet<String>();
        JSONArray nodes = workflow.getJSONArray("nodes");
        for (i = 0; i < nodes.size(); ++i) {
            JSONObject node = nodes.getJSONObject(i);
            String nodeName = node.getString("name");
            Validate.notEmpty((CharSequence)nodeName, (String)"\u8282\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            nodeNameSet.add(nodeName);
        }
        JSONArray jumpArray = workflow.getJSONArray("jumpArray");
        for (i = 0; i < jumpArray.size(); ++i) {
            JSONObject jump = jumpArray.getJSONObject(i);
            String current = jump.getString("current");
            if (!nodeNameSet.contains(current)) {
                throw new IllegalArgumentException("\u672a\u5b9a\u4e49\u7684\u5f53\u524d\u8282\u70b9\u540d\u79f0!\u8282\u70b9\u540d\u79f0:" + current);
            }
            String next = jump.getString("next");
            if (nodeNameSet.contains(next)) continue;
            throw new IllegalArgumentException("\u672a\u5b9a\u4e49\u7684\u4e0b\u4e00\u8282\u70b9\u540d\u79f0!\u8282\u70b9\u540d\u79f0:" + next);
        }
    }

    private void checkStartAndEndNode(FlowContext flowContext) {
        JSONObject workflow = (JSONObject)flowContext.checkData("workflow");
        JSONArray nodes = workflow.getJSONArray("nodes");
        int countOfStart = 0;
        int countOfEnd = 0;
        block4: for (int i = 0; i < nodes.size(); ++i) {
            JSONObject node = nodes.getJSONObject(i);
            Integer type = node.getInteger("type");
            Validate.notNull((Object)type, (String)"\u8282\u70b9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            switch (type) {
                case 0: {
                    ++countOfStart;
                    flowContext.putCurrentFlowData("startNodeName", (Object)node.getString("name"));
                    continue block4;
                }
                case 2: {
                    ++countOfEnd;
                    flowContext.putCurrentFlowData("endNodeName", (Object)node.getString("name"));
                }
            }
        }
        if (countOfStart != 1) {
            throw new IllegalArgumentException("\u5f00\u59cb\u8282\u70b9\u53ea\u80fd\u6709\u4e00\u4e2a!\u5b9e\u9645\u5f00\u59cb\u8282\u70b9\u4e2a\u6570:" + countOfStart);
        }
        if (countOfEnd != 1) {
            throw new IllegalArgumentException("\u7ed3\u675f\u8282\u70b9\u53ea\u80fd\u6709\u4e00\u4e2a!\u5b9e\u9645\u7ed3\u675f\u8282\u70b9\u4e2a\u6570:" + countOfEnd);
        }
    }

    private void checkStartNodeJumpSize(FlowContext flowContext) {
        JSONObject workflow = (JSONObject)flowContext.checkData("workflow");
        String startNodeName = (String)flowContext.checkData("startNodeName");
        JSONArray jumpArray = workflow.getJSONArray("jumpArray");
        int startNodeJumpSize = 0;
        for (int i = 0; i < jumpArray.size(); ++i) {
            JSONObject jump = jumpArray.getJSONObject(i);
            if (!startNodeName.equalsIgnoreCase(jump.getString("current"))) continue;
            ++startNodeJumpSize;
        }
        if (startNodeJumpSize != 1) {
            throw new IllegalArgumentException("\u5f00\u59cb\u8282\u70b9\u53ea\u80fd\u8fde\u63a5\u4e00\u6761\u7ebf!\u5b9e\u9645\u5f00\u59cb\u8282\u70b9\u8fde\u63a5\u4e2a\u6570:" + startNodeJumpSize);
        }
    }
}

