/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.workflow.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class ReflectionUtil {
    public static List getInstanceSingleFieldValueList(List list, String fieldName) {
        ArrayList<Object> fieldValueList = new ArrayList<Object>();
        for (Object instance : list) {
            Object fieldValue = ReflectionUtil.getInstanceFieldValue(instance, fieldName);
            fieldValueList.add(fieldValue);
        }
        return fieldValueList;
    }

    public static List<String> getInstanceFieldValueList(List list, String ... fieldNames) {
        ArrayList<String> fieldValueList = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (Object instance : list) {
            builder.setLength(0);
            for (String fieldName : fieldNames) {
                Object fieldValue = ReflectionUtil.getInstanceFieldValue(instance, fieldName);
                builder.append(fieldValue.toString() + ":");
            }
            builder.deleteCharAt(builder.length() - 1);
            fieldValueList.add(builder.toString());
        }
        return fieldValueList;
    }

    public static Object getInstanceFilterByFieldValue(List list, String fieldName, Object fieldValue) {
        for (Object instance : list) {
            Object actualFieldValue = ReflectionUtil.getInstanceFieldValue(instance, fieldName);
            if (!fieldValue.equals(actualFieldValue)) continue;
            return instance;
        }
        return null;
    }

    public static Object getInstanceFieldValue(Object instance, String fieldName) {
        try {
            Field field = ReflectionUtil.searchFieldFromSuperClass(fieldName, instance.getClass());
            Object value = field.get(instance);
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getInstanceFieldValue(Object instance, String[] fieldNames) {
        Validate.notEmpty((Object[])fieldNames, (String)"\u5b57\u6bb5\u540d\u79f0\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        try {
            if (fieldNames.length == 1) {
                Field field = ReflectionUtil.searchFieldFromSuperClass(fieldNames[0], instance.getClass());
                Object value = field.get(instance);
                return value;
            }
            StringBuilder builder = new StringBuilder();
            for (String fieldName : fieldNames) {
                Field field = ReflectionUtil.searchFieldFromSuperClass(fieldName, instance.getClass());
                Object value = field.get(instance);
                Validate.notNull((Object)value, (String)("\u5b9e\u4f8b\u503c\u67e5\u8be2\u4e3a\u7a7a!\u5b9e\u4f8b\u7c7b:" + instance.getClass().getName() + ",\u5b57\u6bb5\u540d:" + fieldName), (Object[])new Object[0]);
                builder.append(value + ":");
            }
            builder.deleteCharAt(builder.length() - 1);
            return builder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Field searchFieldFromSuperClass(String fieldName, Class clazz) {
        String initialClassName = clazz.getName();
        while (null != clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new IllegalArgumentException("\u5b57\u6bb5\u4e0d\u5b58\u5728!\u5b57\u6bb5\u540d:" + fieldName + ",\u7c7b\u540d:" + initialClassName);
    }
}

