/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.workflow.service.task;

import cn.schoolwow.quickdao.domain.external.PageVo;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import cn.schoolwow.workflow.composite.task.CompleteTaskCompositeBusiness;
import cn.schoolwow.workflow.composite.task.GetPagingTaskListCompositeBusiness;
import cn.schoolwow.workflow.composite.task.GetTaskListCompositeBusiness;
import cn.schoolwow.workflow.contant.TaskType;
import cn.schoolwow.workflow.domain.QuickWorkFlowConfig;
import cn.schoolwow.workflow.domain.request.CompleteTaskRequest;
import cn.schoolwow.workflow.domain.request.WorkFlowTaskQuery;
import cn.schoolwow.workflow.domain.response.WorkFlowTaskResponse;
import cn.schoolwow.workflow.service.task.WorkFlowTaskService;
import java.util.List;

public class WorkFlowTaskServiceImpl
implements WorkFlowTaskService {
    private QuickWorkFlowConfig quickWorkFlowConfig;

    public WorkFlowTaskServiceImpl(QuickWorkFlowConfig quickWorkFlowConfig) {
        this.quickWorkFlowConfig = quickWorkFlowConfig;
    }

    @Override
    public WorkFlowTaskResponse getSingleTask(WorkFlowTaskQuery workFlowTaskQuery) {
        PageVo<WorkFlowTaskResponse> pageVo = this.getPagingTaskList(workFlowTaskQuery, 1, 100);
        if (null == pageVo || null == pageVo.getList() || pageVo.getList().isEmpty()) {
            return null;
        }
        if (pageVo.getTotalSize() > 1L) {
            throw new IllegalArgumentException("\u671f\u671b\u83b7\u53d6\u5355\u4e2a\u5206\u914d\u4efb\u52a1\uff0c\u4f46\u662f\u5b9e\u9645\u4efb\u52a1\u4e2a\u6570\u5927\u4e8e1!\u5b9e\u9645\u4efb\u52a1\u4e2a\u6570:" + pageVo.getTotalSize());
        }
        return (WorkFlowTaskResponse)pageVo.getList().get(0);
    }

    @Override
    public List<WorkFlowTaskResponse> getTaskList(WorkFlowTaskQuery workFlowTaskQuery) {
        FlowContext flowContext = this.quickWorkFlowConfig.workflow.startFlow((CompositeBusinessFlow)new GetTaskListCompositeBusiness()).putCurrentCompositeFlowData("workFlowTaskQuery", (Object)workFlowTaskQuery).execute();
        List list = (List)flowContext.getData("list");
        return list;
    }

    @Override
    public PageVo<WorkFlowTaskResponse> getPagingTaskList(WorkFlowTaskQuery workFlowTaskQuery, int pageNumber, int pageSize) {
        FlowContext flowContext = this.quickWorkFlowConfig.workflow.startFlow((CompositeBusinessFlow)new GetPagingTaskListCompositeBusiness()).putCurrentCompositeFlowData("workFlowTaskQuery", (Object)workFlowTaskQuery).putCurrentCompositeFlowData("pageNumber", (Object)pageNumber).putCurrentCompositeFlowData("pageSize", (Object)pageSize).execute();
        PageVo pageVo = (PageVo)flowContext.checkData("pageVo");
        return pageVo;
    }

    @Override
    public boolean completeTask(long taskId, TaskType taskType) {
        CompleteTaskRequest completeTaskRequest = new CompleteTaskRequest();
        completeTaskRequest.taskId = taskId;
        completeTaskRequest.taskType = taskType;
        return this.completeTask(completeTaskRequest);
    }

    @Override
    public boolean completeTask(CompleteTaskRequest completeTaskRequest) {
        FlowContext flowContext = this.quickWorkFlowConfig.workflow.startFlow((CompositeBusinessFlow)new CompleteTaskCompositeBusiness()).putCurrentCompositeFlowData("completeTaskRequest", (Object)completeTaskRequest).execute();
        boolean instanceFinished = (Boolean)flowContext.getData("instanceFinished", (Object)false);
        return instanceFinished;
    }
}

