/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.workflow.service;

import cn.schoolwow.workflow.domain.QuickWorkFlowConfig;
import cn.schoolwow.workflow.service.deploy.WorkFlowDeploy;
import cn.schoolwow.workflow.service.deploy.WorkFlowDeployImpl;
import cn.schoolwow.workflow.service.execute.WorkFlowInstanceService;
import cn.schoolwow.workflow.service.execute.WorkFlowInstanceServiceImpl;
import cn.schoolwow.workflow.service.option.WorkFlowOption;
import cn.schoolwow.workflow.service.option.WorkFlowOptionImpl;
import cn.schoolwow.workflow.service.task.WorkFlowTaskService;
import cn.schoolwow.workflow.service.task.WorkFlowTaskServiceImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WorkFlowInvocationHandler
implements InvocationHandler {
    private WorkFlowOption workFlowOption;
    private WorkFlowDeploy workFlowDeploy;
    private WorkFlowInstanceService workFlowExecute;
    private WorkFlowTaskService workFlowTaskService;
    private Object[] interfaceInstanceArray;

    public WorkFlowInvocationHandler(QuickWorkFlowConfig quickWorkFlowConfig) {
        this.workFlowOption = new WorkFlowOptionImpl(quickWorkFlowConfig);
        this.workFlowDeploy = new WorkFlowDeployImpl(quickWorkFlowConfig);
        this.workFlowExecute = new WorkFlowInstanceServiceImpl(quickWorkFlowConfig);
        this.workFlowTaskService = new WorkFlowTaskServiceImpl(quickWorkFlowConfig);
        this.interfaceInstanceArray = new Object[]{this.workFlowOption, this.workFlowDeploy, this.workFlowExecute, this.workFlowTaskService};
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String interfaceName = method.getDeclaringClass().getSimpleName();
        for (Object interfaceInstance : this.interfaceInstanceArray) {
            Class<?> interfaceClass = interfaceInstance.getClass().getInterfaces()[0];
            if (!interfaceClass.getSimpleName().equalsIgnoreCase(interfaceName)) continue;
            try {
                return method.invoke(interfaceInstance, args);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                throw targetException;
            }
        }
        throw new IllegalAccessError("\u4e0d\u652f\u6301\u8c03\u7528\u8be5\u65b9\u6cd5!\u65b9\u6cd5\u540d:" + method.getName());
    }
}

