/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.workflow.flow.task.query;

import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import cn.schoolwow.quickdao.dao.dql.subCondition.SubCondition;
import cn.schoolwow.quickdao.provider.DatabaseProvider;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.domain.request.WorkFlowTaskQuery;
import cn.schoolwow.workflow.entity.WorkFlowDefinition;
import cn.schoolwow.workflow.entity.WorkFlowInstance;
import cn.schoolwow.workflow.entity.WorkFlowNode;
import cn.schoolwow.workflow.entity.WorkFlowTask;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SetTaskQueryConditionFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.setCondition(flowContext);
        this.addConditionQuery(flowContext);
    }

    public String name() {
        return "\u8bbe\u7f6e\u5de5\u4f5c\u6d41\u4efb\u52a1\u67e5\u8be2\u5bf9\u8c61";
    }

    private void setCondition(FlowContext flowContext) {
        DAO dao = (DAO)flowContext.checkData("dao");
        DatabaseProvider databaseProvider = dao.getDatabaseProvider();
        Condition condition = dao.query(WorkFlowTask.class).orderByDesc(new String[]{"createdAt"}).addColumn(new String[]{"id " + databaseProvider.escape("taskId")}).addColumn(new String[]{"complete " + databaseProvider.escape("complete")});
        flowContext.putTemporaryData("condition", (Object)condition);
        SubCondition workFlowInstanceSubCondition = condition.joinTable(WorkFlowInstance.class, "instanceId", "id").addColumn(new String[]{"id " + databaseProvider.escape("instanceId")}).addColumn(new String[]{"definitionId " + databaseProvider.escape("definitionId")}).addColumn(new String[]{"initiator " + databaseProvider.escape("initiator")}).addColumn(new String[]{"contextData " + databaseProvider.escape("contextData")});
        flowContext.putTemporaryData("workFlowInstanceSubCondition", (Object)workFlowInstanceSubCondition);
        SubCondition workFlowDefinitionSubCondition = workFlowInstanceSubCondition.joinTable(WorkFlowDefinition.class, "definitionId", "id").addColumn(new String[]{"name " + databaseProvider.escape("definitionName")});
        flowContext.putTemporaryData("workFlowDefinitionSubCondition", (Object)workFlowDefinitionSubCondition);
        SubCondition workFlowNodeSubCondition = condition.joinTable(WorkFlowNode.class, "nodeId", "id").addColumn(new String[]{"name " + dao.getDatabaseProvider().escape("taskName")});
        flowContext.putTemporaryData("workFlowNodeSubCondition", (Object)workFlowNodeSubCondition);
    }

    private void addConditionQuery(FlowContext flowContext) {
        WorkFlowTaskQuery workFlowTaskQuery = (WorkFlowTaskQuery)flowContext.checkData("workFlowTaskQuery");
        Condition condition = (Condition)flowContext.checkData("condition");
        if (null != workFlowTaskQuery.workFlowTaskIdList && !workFlowTaskQuery.workFlowTaskIdList.isEmpty()) {
            condition.addInQuery("id", workFlowTaskQuery.workFlowTaskIdList);
        }
        if (null != workFlowTaskQuery.workFlowInstanceIdList && !workFlowTaskQuery.workFlowInstanceIdList.isEmpty()) {
            condition.addInQuery("instanceId", workFlowTaskQuery.workFlowInstanceIdList);
        }
        if (StringUtils.isNotBlank((CharSequence)workFlowTaskQuery.assigner)) {
            condition.addQuery("assigner", (Object)workFlowTaskQuery.assigner);
        }
        if (null != workFlowTaskQuery.complete) {
            condition.addQuery("complete", (Object)workFlowTaskQuery.complete);
        }
        SubCondition workFlowInstanceSubCondition = (SubCondition)flowContext.checkData("workFlowInstanceSubCondition");
        if (null != workFlowTaskQuery.instanceFinished) {
            workFlowInstanceSubCondition.addQuery("finished", (Object)workFlowTaskQuery.instanceFinished);
        }
        if (null != workFlowTaskQuery.initiator) {
            workFlowInstanceSubCondition.addQuery("initiator", (Object)workFlowTaskQuery.initiator);
        }
        Set keySet = workFlowTaskQuery.contextDataQuery.keySet();
        for (String key : keySet) {
            String value = workFlowTaskQuery.contextDataQuery.getString(key);
            workFlowInstanceSubCondition.addRawQuery("t1.context_data->'" + key + "' = ?", new Object[]{value});
        }
        SubCondition workFlowDefinitionSubCondition = (SubCondition)flowContext.checkData("workFlowDefinitionSubCondition");
        if (StringUtils.isNotBlank((CharSequence)workFlowTaskQuery.definitionName)) {
            workFlowDefinitionSubCondition.addQuery("name", (Object)workFlowTaskQuery.definitionName);
        }
        SubCondition workFlowNodeSubCondition = (SubCondition)flowContext.checkData("workFlowNodeSubCondition");
        if (StringUtils.isNotBlank((CharSequence)workFlowTaskQuery.nodeName)) {
            workFlowNodeSubCondition.addQuery("name", (Object)workFlowTaskQuery.nodeName);
        }
    }
}

