/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.websocket.stream;

import cn.schoolwow.quickserver.websocket.stream.WebSocketStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketStreamImpl
implements WebSocketStream {
    private Logger logger = LoggerFactory.getLogger(WebSocketStreamImpl.class);
    private Socket socket;
    private DataInputStream in;
    private ByteArrayOutputStream baos;
    private DataOutputStream out;
    private Scanner scanner;

    public WebSocketStreamImpl() {
        this.baos = new ByteArrayOutputStream();
        this.out = new DataOutputStream(this.baos);
    }

    public WebSocketStreamImpl(Socket socket) throws IOException {
        this.socket = socket;
        this.in = new DataInputStream(socket.getInputStream());
        this.out = new DataOutputStream(socket.getOutputStream());
        this.scanner = new Scanner(this.in);
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        int length = this.in.read(b);
        if (length != b.length) {
            throw new IllegalArgumentException("\u8bfb\u53d6\u5b57\u8282\u6570\u7ec4\u5931\u8d25\uff01\u671f\u671b\u8bfb\u53d6\u957f\u5ea6:" + b.length + ",\u5b9e\u9645\u8bfb\u53d6\u957f\u5ea6:" + length);
        }
        return length;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int length = this.in.read(b, off, len);
        if (length != len) {
            throw new IllegalArgumentException("\u8bfb\u53d6\u5b57\u8282\u6570\u7ec4\u5931\u8d25\uff01\u671f\u671b\u8bfb\u53d6\u957f\u5ea6:" + len + ",\u5b9e\u9645\u8bfb\u53d6\u957f\u5ea6:" + length);
        }
        return length;
    }

    @Override
    public byte[] readByteArray(int length) throws IOException {
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
        int actualLength = 0;
        int totalLength = length;
        while ((actualLength = this.in.read(buffer, 0, Math.min(buffer.length, totalLength))) != 0) {
            baos1.write(buffer, 0, actualLength);
            totalLength -= actualLength;
        }
        if (baos1.size() != length) {
            throw new IllegalArgumentException("\u8bfb\u53d6\u6307\u5b9a\u957f\u5ea6\u5b57\u8282\u5931\u8d25!\u671f\u671b\u5b57\u8282\u957f\u5ea6:" + length + ",\u5f53\u524d\u5b57\u8282\u957f\u5ea6:" + baos1.size());
        }
        return baos1.toByteArray();
    }

    @Override
    public TreeMap<String, List<String>> readHeaders() throws IOException {
        String line = this.readLine();
        String lastPutName = null;
        TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        while (!"".equals(line)) {
            String value;
            if (line.contains(":") && Character.isLetter(line.charAt(0))) {
                String name = line.substring(0, line.indexOf(58));
                value = line.substring(name.length() + 1).trim();
                List<String> valueList = headers.get(name);
                if (null == valueList) {
                    valueList = new ArrayList<String>();
                }
                valueList.add(value);
                headers.put(name, valueList);
                lastPutName = name;
            } else if (null != lastPutName) {
                List<String> valueList = headers.get(lastPutName);
                value = valueList.get(valueList.size() - 1).trim();
                value = value + line;
                valueList.set(valueList.size() - 1, value);
            }
            if (!this.scanner.hasNextLine()) break;
            line = this.readLine();
        }
        return headers;
    }

    @Override
    public int[] readBitByte() throws IOException {
        return this.readBitByte(1);
    }

    @Override
    public int[] readBitByte(int nByte) throws IOException {
        int[] bits = new int[nByte * 8];
        for (int i = 0; i < nByte; ++i) {
            int b = this.in.read();
            if (b == -1) {
                throw new IOException("\u8f93\u5165\u6d41\u8bfb\u53d6\u5230\u672b\u5c3e\u4e86!");
            }
            for (int j = 0; j < 8; ++j) {
                int n = 1 << 7 - j;
                int result = b & n;
                bits[i * 8 + j] = result == n ? 1 : 0;
            }
        }
        return bits;
    }

    @Override
    public void writeLine(String line) throws IOException {
        this.out.write((line + "\r\n").getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void writeBit(int[] bits) throws IOException {
        if (bits.length % 8 != 0) {
            throw new IllegalArgumentException("bits\u53c2\u6570\u957f\u5ea6\u5fc5\u987b\u4e3a8\u7684\u500d\u6570!");
        }
        int byteCount = bits.length / 8;
        for (int i = 0; i < byteCount; ++i) {
            int b = 0;
            for (int j = 0; j < 8; ++j) {
                b |= bits[i * 8 + j] << 7 - j;
            }
            this.write(b);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public int size() {
        return this.out.size();
    }

    @Override
    public byte[] toByteArray() {
        return this.baos.toByteArray();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.in.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.in.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.in.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.in.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.in.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.in.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.scanner.nextLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.in.readUTF();
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.out.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.out.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.out.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.out.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.out.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.out.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.out.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.out.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.out.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.out.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.out.writeUTF(s);
    }

    @Override
    public void close() {
        if (null == this.socket) {
            return;
        }
        try {
            this.in.close();
            this.out.close();
            this.scanner.close();
            this.socket.close();
        }
        catch (IOException e) {
            this.logger.error("\u5173\u95ed\u5957\u63a5\u5b57\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }
}

