/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.websocket.stream;

import cn.schoolwow.quickserver.exception.HttpStatusException;
import cn.schoolwow.quickserver.util.BitUtil;
import cn.schoolwow.quickserver.util.QuickServerUtil;
import cn.schoolwow.quickserver.websocket.domain.CloseCode;
import cn.schoolwow.quickserver.websocket.domain.OPCode;
import cn.schoolwow.quickserver.websocket.domain.WebSocketFrame;
import cn.schoolwow.quickserver.websocket.stream.WebSocketFrameStream;
import cn.schoolwow.quickserver.websocket.stream.WebSocketStream;
import cn.schoolwow.quickserver.websocket.stream.WebSocketStreamImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketFrameStreamImpl
implements WebSocketFrameStream {
    private Logger logger = LoggerFactory.getLogger(WebSocketFrameStreamImpl.class);
    private static final int FRAGMENT_SIZE = 0x100000;
    private WebSocketStream webSocketStream;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();

    public WebSocketFrameStreamImpl(WebSocketStream webSocketStream) {
        this.webSocketStream = webSocketStream;
    }

    @Override
    public WebSocketFrame getClientWebSocketFrame() throws IOException {
        WebSocketFrame webSocketFrame = this.getCompleteDataFrame();
        if (!webSocketFrame.mask) {
            WebSocketFrame closeWebSocketFrame = WebSocketFrame.newInstance().opCode(OPCode.Close).closeCode(CloseCode.PROTOCOL_ERROR).mask(true);
            this.writeWebSocketFrame(closeWebSocketFrame);
            this.webSocketStream.close();
            throw new IOException("\u5ba2\u6237\u7aef\u6570\u636e\u5e27\u672a\u8bbe\u7f6e\u63a9\u7801!");
        }
        return webSocketFrame;
    }

    @Override
    public WebSocketFrame getServerWebSocketFrame() throws IOException {
        WebSocketFrame webSocketFrame = this.getCompleteDataFrame();
        if (webSocketFrame.mask) {
            WebSocketFrame closeWebSocketFrame = WebSocketFrame.newInstance().opCode(OPCode.Close).closeCode(CloseCode.PROTOCOL_ERROR).mask(true);
            this.writeWebSocketFrame(closeWebSocketFrame);
            this.webSocketStream.close();
            throw new IOException("\u670d\u52a1\u7aef\u6570\u636e\u5e27\u8bbe\u7f6e\u4e86\u63a9\u7801!");
        }
        return webSocketFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeWebSocketFrame(WebSocketFrame webSocketFrame) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (null == webSocketFrame.payload || webSocketFrame.payload.length < 0x100000) {
                this.doWriteWebSocketFrame(webSocketFrame);
                return;
            }
            ByteArrayInputStream baos = new ByteArrayInputStream(webSocketFrame.payload);
            byte[] fragmentBytes = new byte[0x100000];
            int total = 0;
            int length = baos.read(fragmentBytes, 0, fragmentBytes.length);
            WebSocketFrame startWebSocketFrame = WebSocketFrame.newInstance().fin(false).opCode(webSocketFrame.opCode).mask(webSocketFrame.mask).payload(fragmentBytes);
            this.logger.trace("\u53d1\u9001\u8d77\u59cb\u5e27,\u6570\u636e\u957f\u5ea6\u8303\u56f4:{}-{}", (Object)0, (Object)(total += length));
            this.doWriteWebSocketFrame(startWebSocketFrame);
            while ((length = baos.read(fragmentBytes, 0, fragmentBytes.length)) == fragmentBytes.length) {
                WebSocketFrame continueWebSocketFrame = WebSocketFrame.newInstance().fin(false).opCode(OPCode.ContinueFrame).mask(webSocketFrame.mask).payload(fragmentBytes);
                this.logger.trace("\u53d1\u9001\u6301\u7eed\u5e27,\u6570\u636e\u957f\u5ea6\u8303\u56f4:{}-{}", (Object)total, (Object)(total + length));
                total += length;
                this.doWriteWebSocketFrame(continueWebSocketFrame);
            }
            byte[] endFragmentBytes = new byte[length];
            System.arraycopy(fragmentBytes, 0, endFragmentBytes, 0, endFragmentBytes.length);
            WebSocketFrame endWebSocketFrame = WebSocketFrame.newInstance().fin(true).opCode(OPCode.ContinueFrame).mask(webSocketFrame.mask).payload(endFragmentBytes);
            this.logger.trace("\u53d1\u9001\u7ed3\u5c3e\u5e27,\u6570\u636e\u957f\u5ea6\u8303\u56f4:{}-{}", (Object)total, (Object)(total + length));
            this.doWriteWebSocketFrame(endWebSocketFrame);
            baos.close();
        }
    }

    @Override
    public WebSocketStream getWebSocketStream() {
        return this.webSocketStream;
    }

    private WebSocketFrame getWebSocketFrame() throws IOException {
        WebSocketFrame webSocketFrame = new WebSocketFrame();
        int[] bits = this.webSocketStream.readBitByte();
        webSocketFrame.fin = bits[0] == 1;
        webSocketFrame.opCode = OPCode.getOPCode(BitUtil.getBitValue(bits, 4, 7));
        this.logger.trace("\u8bfb\u53d6websocket\u5e27\u7b2c1\u4e2a\u5b57\u8282:{}", (Object)Arrays.toString(bits));
        bits = this.webSocketStream.readBitByte();
        webSocketFrame.mask = bits[0] == 1;
        webSocketFrame.payloadLength = BitUtil.getBitValue(bits, 1, 7);
        if (webSocketFrame.payloadLength == 126L) {
            this.logger.trace("\u8d1f\u8f7d\u957f\u5ea6\u4e3a126,\u8bfb\u53d6\u63a5\u4e0b\u67652\u4e2a\u5b57\u8282\u4f5c\u4e3a\u5b9e\u9645\u957f\u5ea6!");
            webSocketFrame.payloadLength = this.webSocketStream.readShort();
        } else if (webSocketFrame.payloadLength == 127L) {
            this.logger.trace("\u8d1f\u8f7d\u957f\u5ea6\u4e3a127,\u8bfb\u53d6\u63a5\u4e0b\u67658\u4e2a\u5b57\u8282\u4f5c\u4e3a\u5b9e\u9645\u957f\u5ea6!");
            webSocketFrame.payloadLength = this.webSocketStream.readLong();
        }
        this.logger.trace("\u8d1f\u8f7d\u6570\u636e\u957f\u5ea6\u4e3a:{}\u5b57\u8282", (Object)webSocketFrame.payloadLength);
        if (webSocketFrame.mask) {
            webSocketFrame.maskKey = new byte[4];
            int length = this.webSocketStream.read(webSocketFrame.maskKey, 0, webSocketFrame.maskKey.length);
            this.logger.trace("\u8bfb\u53d6\u63a9\u7801!key\u957f\u5ea6:{},\u503c:{}", (Object)length, (Object)Arrays.toString(webSocketFrame.maskKey));
            if (length != webSocketFrame.maskKey.length) {
                throw new HttpStatusException(400, "\u8bfb\u53d6\u63a9\u7801\u5931\u8d25!\u9884\u671f\u5b57\u8282\u957f\u5ea6:4,\u5b9e\u9645\u957f\u5ea6:" + length);
            }
        }
        webSocketFrame.payload = new byte[(int)webSocketFrame.payloadLength];
        this.webSocketStream.read(webSocketFrame.payload, 0, webSocketFrame.payload.length);
        if (webSocketFrame.mask && webSocketFrame.payloadLength > 0L) {
            this.logger.trace("\u670d\u52a1\u7aef\u8fdb\u884c\u53cd\u63a9\u7801\u64cd\u4f5c,\u63a9\u7801key:{},\u8d1f\u8f7d\u6570\u636e\u957f\u5ea6:{}", (Object)Arrays.toString(webSocketFrame.maskKey), (Object)webSocketFrame.payload.length);
            this.mask(webSocketFrame.payload, webSocketFrame.maskKey);
        }
        if (OPCode.Close.equals((Object)webSocketFrame.opCode)) {
            webSocketFrame.closeCode = CloseCode.getCloseCodeByCode(webSocketFrame.payload);
        }
        return webSocketFrame;
    }

    private void doWriteWebSocketFrame(WebSocketFrame webSocketFrame) throws IOException {
        try (WebSocketStreamImpl cacheStream = new WebSocketStreamImpl();){
            int[] bits = new int[8];
            bits[0] = webSocketFrame.fin ? 1 : 0;
            BitUtil.setBitValue(bits, 4, 7, webSocketFrame.opCode.value);
            this.logger.trace("\u5199\u5165websocket\u5e27\u7b2c1\u4e2a\u5b57\u8282:{}", (Object)Arrays.toString(bits));
            cacheStream.writeBit(bits);
            bits = new int[8];
            int n = bits[0] = webSocketFrame.mask ? 1 : 0;
            if (webSocketFrame.payloadLength < 126L) {
                BitUtil.setBitValue(bits, 1, 7, (int)webSocketFrame.payloadLength);
                cacheStream.writeBit(bits);
                this.logger.trace("\u5199\u5165websocket\u5e27\u7b2c2\u4e2a\u5b57\u8282:{},\u8d1f\u8f7d\u6570\u636e\u957f\u5ea6:{}", (Object)Arrays.toString(bits), (Object)webSocketFrame.payloadLength);
            } else if (webSocketFrame.payloadLength < 32767L) {
                BitUtil.setBitValue(bits, 1, 7, 126);
                cacheStream.writeBit(bits);
                cacheStream.writeShort((int)webSocketFrame.payloadLength);
                this.logger.trace("\u5199\u5165websocket\u5e27\u7b2c2\u4e2a\u5b57\u8282:{},126+{}(\u5927\u5c0f\u53602\u5b57\u8282)", (Object)Arrays.toString(bits), (Object)webSocketFrame.payloadLength);
            } else {
                BitUtil.setBitValue(bits, 1, 7, 127);
                cacheStream.writeBit(bits);
                cacheStream.writeLong(webSocketFrame.payloadLength);
                this.logger.trace("\u5199\u5165websocket\u5e27\u7b2c2\u4e2a\u5b57\u8282:{},127+{}(\u5927\u5c0f\u53608\u5b57\u8282)", (Object)Arrays.toString(bits), (Object)webSocketFrame.payloadLength);
            }
            if (webSocketFrame.mask) {
                cacheStream.write(webSocketFrame.maskKey);
                this.logger.trace("\u5199\u5165\u63a9\u7801key:{}", (Object)Arrays.toString(webSocketFrame.maskKey));
                if (OPCode.Close.equals((Object)webSocketFrame.opCode)) {
                    this.logger.trace("\u5199\u5165\u5173\u95ed\u72b6\u6001\u7801:{}", (Object)webSocketFrame.closeCode);
                } else if (null != webSocketFrame.payload) {
                    this.logger.trace("\u5199\u5165\u8d1f\u8f7d\u6570\u636e,\u957f\u5ea6:{}, \u6587\u672c:{}, \u5341\u516d\u8fdb\u5236:{}", new Object[]{webSocketFrame.payloadLength, new String(webSocketFrame.payload, StandardCharsets.UTF_8), QuickServerUtil.byteArrayToHex(webSocketFrame.payload)});
                }
                if (webSocketFrame.payloadLength > 0L && null != webSocketFrame.payload) {
                    this.mask(webSocketFrame.payload, webSocketFrame.maskKey);
                }
            }
            if (null != webSocketFrame.payload) {
                cacheStream.write(webSocketFrame.payload);
            }
            this.webSocketStream.write(cacheStream.toByteArray());
            this.webSocketStream.flush();
            if (webSocketFrame.mask && webSocketFrame.payloadLength > 0L && null != webSocketFrame.payload) {
                this.mask(webSocketFrame.payload, webSocketFrame.maskKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebSocketFrame getCompleteDataFrame() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            WebSocketFrame webSocketFrame = this.getWebSocketFrame();
            boolean fin = webSocketFrame.fin;
            while (!fin) {
                this.logger.trace("\u5f53\u524d\u5e27\u4e0d\u662f\u6700\u540e\u4e00\u4e2a\u7247\u6bb5!\u7ee7\u7eed\u8bfb\u53d6\u4e0b\u4e00\u4e2a\u5e27!");
                this.logger.trace("\u5f53\u524d\u8d1f\u8f7d\u957f\u5ea6:{}", (Object)webSocketFrame.payload.length);
                WebSocketFrame nextFrame = this.getWebSocketFrame();
                byte[] data = new byte[nextFrame.payload.length + nextFrame.payload.length];
                System.arraycopy(webSocketFrame.payload, 0, data, 0, webSocketFrame.payload.length);
                System.arraycopy(nextFrame.payload, 0, data, webSocketFrame.payload.length, nextFrame.payload.length);
                webSocketFrame.payload = data;
                this.logger.trace("\u5f85\u590d\u5236\u5e27\u957f\u5ea6:{},\u590d\u5236\u4ee5\u540e\u8d1f\u8f7d\u957f\u5ea6:{}", (Object)nextFrame.payload.length, (Object)webSocketFrame.payload.length);
                fin = nextFrame.fin;
            }
            return webSocketFrame;
        }
    }

    private void mask(byte[] payload, byte[] maskKey) {
        for (int i = 0; i < payload.length; ++i) {
            payload[i] = (byte)(payload[i] ^ maskKey[i % 4]);
        }
    }
}

