/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.websocket.domain;

import cn.schoolwow.quickserver.util.QuickServerUtil;
import cn.schoolwow.quickserver.websocket.domain.CloseCode;
import cn.schoolwow.quickserver.websocket.domain.OPCode;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class WebSocketFrame {
    public boolean fin = true;
    public OPCode opCode;
    public CloseCode closeCode = CloseCode.NORMAL_CLOSURE;
    public boolean mask;
    public long payloadLength;
    public byte[] maskKey;
    public byte[] payload;

    public static WebSocketFrame newInstance() {
        return new WebSocketFrame();
    }

    public WebSocketFrame fin(boolean fin) {
        this.fin = fin;
        return this;
    }

    public WebSocketFrame opCode(OPCode opCode) {
        this.opCode = opCode;
        if (OPCode.Close.equals((Object)opCode)) {
            this.closeCode(CloseCode.NORMAL_CLOSURE);
        }
        return this;
    }

    public WebSocketFrame closeCode(CloseCode closeCode) {
        this.closeCode = closeCode;
        this.payloadLength = 2L;
        this.payload = new byte[2];
        this.payload[0] = (byte)(closeCode.code >> 8);
        this.payload[1] = (byte)closeCode.code;
        return this;
    }

    public WebSocketFrame mask(boolean mask) {
        this.mask = mask;
        if (mask) {
            this.maskKey = new byte[4];
            QuickServerUtil.randomBytes(this.maskKey);
        }
        return this;
    }

    public WebSocketFrame payload(byte[] payload) {
        this.payload = payload;
        this.payloadLength = payload.length;
        return this;
    }

    public String toString() {
        return "{\u662f\u5426\u662f\u6700\u540e\u4e00\u4e2a\u5206\u7247:" + this.fin + ",\u64cd\u4f5c\u4ee3\u7801:" + this.opCode.name() + ",\u662f\u5426\u8fdb\u884c\u63a9\u7801:" + this.mask + ",\u8f7d\u8377\u957f\u5ea6:" + this.payloadLength + ",\u63a9\u7801key:" + Arrays.toString(this.maskKey) + ",\u5b9e\u9645\u8f7d\u8377\u6570\u636e:" + (OPCode.TextFrame.equals((Object)this.opCode) ? new String(this.payload, StandardCharsets.UTF_8) : QuickServerUtil.byteArrayToHex(this.payload)) + "}";
    }
}

