/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.websocket.domain;

public enum CloseCode {
    NORMAL_CLOSURE(1000, "\u6b63\u5e38\u5173\u95ed"),
    GOING_AWAY(1001, "\u7ec8\u7aef\u79bb\u7ebf"),
    PROTOCOL_ERROR(1002, "\u534f\u8bae\u9519\u8bef"),
    CANNOT_ACCEPT(1003, "\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b"),
    RESERVED(1004, "\u4fdd\u7559"),
    NO_STATUS_CODE(1005, "\u4fdd\u7559"),
    CLOSED_ABNORMALLY(1006, "\u4fdd\u7559"),
    NOT_CONSISTENT(1007, "\u7c7b\u578b\u4e0d\u8fde\u7eed\u7684\u6d88\u606f"),
    VIOLATED_POLICY(1008, "\u8fdd\u53cd\u653f\u7b56\u7684\u6d88\u606f"),
    TOO_BIG(1009, "\u6d88\u606f\u8d85\u8fc7\u9650\u5236\u5927\u5c0f"),
    NO_EXTENSION(1010, "\u6269\u5c55\u534f\u8bae\u534f\u5546\u5931\u8d25"),
    UNEXPECTED_CONDITION(1011, "\u5185\u90e8\u670d\u52a1\u5668\u9519\u8bef"),
    SERVICE_RESTART(1012, "\u670d\u52a1\u6b63\u5728\u91cd\u542f"),
    TRY_AGAIN_LATER(1013, "\u7a0d\u540e\u91cd\u8bd5"),
    TLS_HANDSHAKE_FAILURE(1015, "TLS\u63e1\u624b\u5931\u8d25");

    public int code;
    public String message;

    private CloseCode(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public String toString() {
        return this.code + "(" + this.message + ")";
    }

    public static CloseCode getCloseCodeByCode(byte[] payload) {
        CloseCode[] closeCodes;
        int code = ((payload[0] & 0xFF) << 8) + (payload[1] & 0xFF);
        for (CloseCode closeCode : closeCodes = CloseCode.values()) {
            if (closeCode.code != code) continue;
            return closeCode;
        }
        return null;
    }
}

