/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.websocket;

import cn.schoolwow.quickserver.websocket.WebSocketSession;
import cn.schoolwow.quickserver.websocket.domain.OPCode;
import cn.schoolwow.quickserver.websocket.domain.WebSocketFrame;
import cn.schoolwow.quickserver.websocket.domain.WebSocketState;
import cn.schoolwow.quickserver.websocket.stream.WebSocketFrameStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;

public class WebSocketSessionImpl
implements WebSocketSession {
    public WebSocketFrameStream webSocketFrameStream;
    public WebSocketState webSocketStatus = WebSocketState.Connecting;

    public WebSocketSessionImpl(WebSocketFrameStream webSocketFrameStream) {
        this.webSocketFrameStream = webSocketFrameStream;
    }

    @Override
    public void sendText(String text) throws IOException {
        WebSocketFrame webSocketFrame = new WebSocketFrame();
        webSocketFrame.fin = true;
        webSocketFrame.opCode = OPCode.TextFrame;
        webSocketFrame.mask = false;
        webSocketFrame.payload = text.getBytes(StandardCharsets.UTF_8);
        webSocketFrame.payloadLength = webSocketFrame.payload.length;
        this.webSocketFrameStream.writeWebSocketFrame(webSocketFrame);
    }

    @Override
    public void sendBinary(byte[] data) throws IOException {
        WebSocketFrame webSocketFrame = new WebSocketFrame();
        webSocketFrame.fin = true;
        webSocketFrame.opCode = OPCode.BinaryFrame;
        webSocketFrame.mask = false;
        webSocketFrame.payload = data;
        webSocketFrame.payloadLength = data.length;
        this.webSocketFrameStream.writeWebSocketFrame(webSocketFrame);
    }

    @Override
    public void close() throws IOException {
        this.webSocketStatus = WebSocketState.Closing;
        if (this.webSocketFrameStream.getWebSocketStream().getSocket().isConnected()) {
            WebSocketFrame webSocketFrame = new WebSocketFrame();
            webSocketFrame.fin = true;
            webSocketFrame.opCode = OPCode.Close;
            webSocketFrame.mask = false;
            this.webSocketFrameStream.writeWebSocketFrame(webSocketFrame);
        }
        this.webSocketStatus = WebSocketState.Closed;
        this.webSocketFrameStream.getWebSocketStream().close();
    }

    @Override
    public Socket getSocket() {
        return this.webSocketFrameStream.getWebSocketStream().getSocket();
    }
}

