/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickserver.util;

import cn.schoolwow.quickserver.domain.Client;
import cn.schoolwow.quickserver.exception.HttpStatusException;
import cn.schoolwow.quickserver.response.HttpStatus;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Map;
import java.util.StringTokenizer;

public class QuickServerUtil {
    private static final ThreadLocal<ByteArrayOutputStream> threadLocal = new ThreadLocal();
    private static SecureRandom secWebSocketKeyRandom = new SecureRandom();

    public static void handleExceptionHandler(Client client, Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        client.httpResponse.httpStatus(HttpStatus.INTERNAL_SERVER_ERROR);
        if (e instanceof HttpStatusException) {
            HttpStatusException httpStatusException = (HttpStatusException)e;
            client.httpResponse.httpStatus(HttpStatus.getStatus(httpStatusException.getStatus()));
        }
        if (null == client.serverConfigMeta.exceptionHandler) {
            if (!(e instanceof HttpStatusException) && !(e instanceof SocketException)) {
                e.printStackTrace();
            }
            client.httpResponse.status(HttpStatus.INTERNAL_SERVER_ERROR);
            client.httpResponseMeta.result = e.getMessage();
            if (null == client.httpResponseMeta.result) {
                client.httpResponseMeta.result = "\u7a7a\u6307\u9488\u5f02\u5e38!";
            }
        } else {
            Object result = client.serverConfigMeta.exceptionHandler.beforeBodyWrite(e, client.httpRequest, client.httpResponse, client.httpSession);
            if (null != result) {
                client.httpResponseMeta.result = client.httpResponseMeta.result = JSON.toJSONStringWithDateFormat((Object)result, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
            }
        }
        client.httpResponseMeta.contentType = "application/json";
        byte[] bytes = client.httpResponseMeta.result.getBytes(StandardCharsets.UTF_8);
        client.httpResponseMeta.contentLength = bytes.length;
        client.httpResponseMeta.bodyInputStream = new ByteArrayInputStream(bytes);
    }

    public static void handleFormData(String body, Map<String, String> dataMap, String charset) throws UnsupportedEncodingException {
        StringTokenizer st = new StringTokenizer(body, "&");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            String key = token.substring(0, token.indexOf("="));
            String value = token.endsWith("=") ? "" : token.substring(token.indexOf("=") + 1);
            dataMap.put(key, URLDecoder.decode(value, charset));
        }
    }

    public static String readLine(InputStream inputStream, String charset) throws IOException {
        int b;
        ByteArrayOutputStream baos = threadLocal.get();
        if (null == baos) {
            baos = new ByteArrayOutputStream();
            threadLocal.set(baos);
        }
        baos.reset();
        while ((b = inputStream.read()) != -1) {
            if (b == 13) {
                b = inputStream.read();
                if (b == 10) break;
                baos.write(13);
                baos.write(b);
                continue;
            }
            baos.write(b);
        }
        if (b == -1) {
            inputStream.close();
            return null;
        }
        baos.flush();
        return new String(baos.toByteArray(), charset);
    }

    public static String byteArrayToHex(byte[] bytes) {
        if (null == bytes || bytes.length == 0) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
        }
        return sb.toString().toUpperCase();
    }

    public static byte[] hexToByteArray(String hex) {
        if (null == hex || hex.isEmpty()) {
            return null;
        }
        byte[] result = new byte[hex.length() / 2];
        int i = 0;
        for (int j = 0; j < result.length; ++j) {
            result[j] = (byte)Integer.parseInt(hex.substring(i, i + 2), 16);
            i += 2;
        }
        return result;
    }

    public static void randomBytes(byte[] bytes) {
        secWebSocketKeyRandom.nextBytes(bytes);
    }

    public static String calculateSecWebSocketAccept(String secWebSocketKey) throws NoSuchAlgorithmException {
        byte[] plainText = (secWebSocketKey + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes();
        byte[] shaEncoded = MessageDigest.getInstance("SHA").digest(plainText);
        String secWebSocketAccept = Base64.getEncoder().encodeToString(shaEncoded);
        return secWebSocketAccept;
    }
}

